/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.parser;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.parser.Event;
import com.corundumstudio.socketio.parser.JsonSupport;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.parser.UTF8CharsScanner;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Queue;

public class Encoder {
    private final UTF8CharsScanner charsScanner = new UTF8CharsScanner();
    private final JsonSupport jsonSupport;
    private final Configuration configuration;
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    public Encoder(Configuration configuration, JsonSupport jsonSupport) {
        this.jsonSupport = jsonSupport;
        this.configuration = configuration;
    }

    public void encodeJsonP(String param, String msg, ByteBuf out) throws IOException {
        String message = "io.j[" + param + "](" + this.jsonSupport.writeValueAsString(msg) + ");";
        out.writeBytes(message.getBytes());
    }

    public ByteBuf allocateBuffer(ByteBufAllocator allocator) {
        if (this.configuration.isPreferDirectBuffer()) {
            return allocator.ioBuffer();
        }
        return allocator.heapBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodePackets(Queue<Packet> packets, ByteBuf buffer, ByteBufAllocator allocator) throws IOException {
        if (packets.size() == 1) {
            Packet packet = packets.poll();
            this.encodePacket(packet, buffer);
        } else {
            Packet packet;
            int counter = 0;
            while ((packet = packets.poll()) != null) {
                if (++counter == 100) {
                    return;
                }
                ByteBuf packetBuffer = this.allocateBuffer(allocator);
                try {
                    int len = this.encodePacketWithLength(packet, packetBuffer);
                    byte[] lenBytes = this.toChars(len);
                    buffer.writeBytes(Packet.DELIMITER_BYTES);
                    buffer.writeBytes(lenBytes);
                    buffer.writeBytes(Packet.DELIMITER_BYTES);
                    buffer.writeBytes(packetBuffer);
                }
                finally {
                    packetBuffer.release();
                }
            }
        }
    }

    private byte toChar(int number) {
        return (byte)(number ^ 0x30);
    }

    static int stringSize(long x) {
        int i = 0;
        while (x > (long)sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    static void getChars(long i, int index, byte[] buf) {
        long r;
        long q;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536L) {
            q = i / 100L;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = (byte)DigitOnes[(int)r];
            buf[--charPos] = (byte)DigitTens[(int)r];
        }
        do {
            q = i * 52429L >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = (byte)digits[(int)r];
        } while ((i = q) != 0L);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    private byte[] toChars(long i) {
        int size = i < 0L ? Encoder.stringSize(-i) + 1 : Encoder.stringSize(i);
        byte[] buf = new byte[size];
        Encoder.getChars(i, size, buf);
        return buf;
    }

    public void encodePacket(Packet packet, ByteBuf buffer) throws IOException {
        ByteBufOutputStream out = new ByteBufOutputStream(buffer);
        int type = packet.getType().getValue();
        buffer.writeByte((int)this.toChar(type));
        buffer.writeByte(58);
        Long id = packet.getId();
        String endpoint = packet.getEndpoint();
        Object ack = packet.getAck();
        if ("data".equals(ack)) {
            buffer.writeBytes(this.toChars(id));
            buffer.writeByte(43);
        } else if (id != null) {
            buffer.writeBytes(this.toChars(id));
        }
        buffer.writeByte(58);
        if (endpoint != null) {
            buffer.writeBytes(endpoint.getBytes());
        }
        switch (packet.getType()) {
            case MESSAGE: {
                if (packet.getData() == null) break;
                buffer.writeByte(58);
                byte[] data = packet.getData().toString().getBytes();
                buffer.writeBytes(data);
                break;
            }
            case EVENT: {
                List<Object> args = packet.getArgs();
                if (args.isEmpty()) {
                    args = null;
                }
                buffer.writeByte(58);
                Event event = new Event(packet.getName(), args);
                this.jsonSupport.writeValue(out, event);
                break;
            }
            case JSON: {
                buffer.writeByte(58);
                this.jsonSupport.writeValue(out, packet.getData());
                break;
            }
            case CONNECT: {
                if (packet.getQs() == null) break;
                buffer.writeByte(58);
                byte[] qsData = packet.getQs().toString().getBytes();
                buffer.writeBytes(qsData);
                break;
            }
            case ACK: {
                if (packet.getAckId() != null || !packet.getArgs().isEmpty()) {
                    buffer.writeByte(58);
                }
                if (packet.getAckId() != null) {
                    byte[] ackIdData = this.toChars(packet.getAckId());
                    buffer.writeBytes(ackIdData);
                }
                if (packet.getArgs().isEmpty()) break;
                buffer.writeByte(43);
                this.jsonSupport.writeValue(out, packet.getArgs());
                break;
            }
            case ERROR: {
                if (packet.getReason() != null || packet.getAdvice() != null) {
                    buffer.writeByte(58);
                }
                if (packet.getReason() != null) {
                    int reasonCode = packet.getReason().getValue();
                    buffer.writeByte((int)this.toChar(reasonCode));
                }
                if (packet.getAdvice() == null) break;
                int adviceCode = packet.getAdvice().getValue();
                buffer.writeByte(43);
                buffer.writeByte((int)this.toChar(adviceCode));
            }
        }
    }

    private int encodePacketWithLength(Packet packet, ByteBuf buffer) throws IOException {
        int start = buffer.writerIndex();
        this.encodePacket(packet, buffer);
        return this.charsScanner.getLength(buffer, start);
    }
}

