/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.UserAgentRequestFilter;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpClient;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpClientConfig;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpUriBuilder;
import com.facebook.presto.jdbc.internal.airlift.http.client.JsonResponseHandler;
import com.facebook.presto.jdbc.internal.airlift.http.client.Request;
import com.facebook.presto.jdbc.internal.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.presto.jdbc.internal.airlift.http.client.jetty.JettyIoPool;
import com.facebook.presto.jdbc.internal.airlift.http.client.jetty.JettyIoPoolConfig;
import com.facebook.presto.jdbc.internal.airlift.json.JsonCodec;
import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.client.ClientSession;
import com.facebook.presto.jdbc.internal.client.QueryResults;
import com.facebook.presto.jdbc.internal.client.ServerInfo;
import com.facebook.presto.jdbc.internal.client.StatementClient;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableSet;
import com.facebook.presto.jdbc.internal.guava.net.HostAndPort;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class QueryExecutor
implements Closeable {
    private final JsonCodec<QueryResults> queryInfoCodec;
    private final JsonCodec<ServerInfo> serverInfoCodec;
    private final HttpClient httpClient;

    private QueryExecutor(JsonCodec<QueryResults> queryResultsCodec, JsonCodec<ServerInfo> serverInfoCodec, HttpClient httpClient) {
        this.queryInfoCodec = Objects.requireNonNull(queryResultsCodec, "queryResultsCodec is null");
        this.serverInfoCodec = Objects.requireNonNull(serverInfoCodec, "serverInfoCodec is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
    }

    public StatementClient startQuery(ClientSession session, String query) {
        return new StatementClient(this.httpClient, this.queryInfoCodec, session, query);
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    public ServerInfo getServerInfo(URI server) {
        URI uri = HttpUriBuilder.uriBuilderFrom(server).replacePath("/v1/info").build();
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        return (ServerInfo)this.httpClient.execute(request, JsonResponseHandler.createJsonResponseHandler(this.serverInfoCodec));
    }

    protected void finalize() {
        this.close();
    }

    static QueryExecutor create(String userAgent) {
        return QueryExecutor.create(new JettyHttpClient(new HttpClientConfig().setConnectTimeout(new Duration(10.0, TimeUnit.SECONDS)).setSocksProxy(QueryExecutor.getSystemSocksProxy()), new JettyIoPool("presto-jdbc", new JettyIoPoolConfig()), ImmutableSet.of(new UserAgentRequestFilter(userAgent))));
    }

    static QueryExecutor create(HttpClient httpClient) {
        return new QueryExecutor(JsonCodec.jsonCodec(QueryResults.class), JsonCodec.jsonCodec(ServerInfo.class), httpClient);
    }

    @Nullable
    private static HostAndPort getSystemSocksProxy() {
        URI uri = URI.create("socket://0.0.0.0:80");
        for (Proxy proxy : ProxySelector.getDefault().select(uri)) {
            if (proxy.type() != Proxy.Type.SOCKS || !(proxy.address() instanceof InetSocketAddress)) continue;
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            return HostAndPort.fromParts(address.getHostString(), address.getPort());
        }
        return null;
    }
}

