/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.kit;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jfinal.ext.kit.ModelExt;
import com.jfinal.log.Logger;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.codec.binary.Hex;

public abstract class ModelFingerprint<M extends ModelFingerprint<M>>
extends ModelExt<M> {
    private static Logger LOG = Logger.getLogger(ModelFingerprint.class);
    private String fingerprintColumnLabel = "fingerprint";
    private ConcurrentMap<String, Integer> map = null;
    private Set<Integer> deleting = null;
    private Set<String> CACHE = Sets.newHashSet();
    private String fingerprint;
    private Class<? extends ModelExt<M>> clazz;

    public ModelFingerprint() {
        Type genericSuperclass = ((Object)((Object)this)).getClass().getGenericSuperclass();
        this.clazz = (Class)((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
    }

    public String tableName() {
        return TableMapping.me().getTable(((Object)((Object)this)).getClass()).getName();
    }

    public void init() {
        this.map = Maps.newConcurrentMap();
        Table tableInfo = TableMapping.me().getTable(this.clazz);
        if (!tableInfo.hasColumnLabel(this.fingerprintColumnLabel)) {
            throw new ActiveRecordException("fingerprintColumnLabel (" + this.fingerprintColumnLabel + ") is not exist");
        }
        LOG.info("begin load " + this.tableName() + " fingerprints");
        List records = Db.find((String)("SELECT id, " + this.fingerprintColumnLabel + " FROM " + this.tableName()));
        for (Record record : records) {
            this.map.put(record.getStr(this.fingerprintColumnLabel), record.getInt("id"));
        }
        LOG.info("end load " + this.tableName() + " fingerprints");
        this.deleting = Sets.newHashSet(this.map.values());
        LOG.info("loaded " + this.deleting.size() + " data");
    }

    public abstract List<String> fingerprintColumns();

    public abstract ModelFingerprint fingerprinter();

    public String calcFingerprint() {
        if (this.fingerprint == null) {
            StringBuilder sb = new StringBuilder();
            for (String col : this.fingerprintColumns()) {
                sb.append(this.get(col));
                sb.append("|");
            }
            sb.deleteCharAt(sb.length() - 1);
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                this.fingerprint = Hex.encodeHexString((byte[])md.digest(sb.toString().getBytes()));
            }
            catch (Exception e) {
                this.fingerprint = "" + this.hashCode();
            }
        }
        return this.fingerprint;
    }

    public void compare(ModelFingerprint modelFingerprint) {
        if (this.map == null) {
            throw new IllegalStateException("modelFingerprint have not been initialized");
        }
        Integer id = (Integer)this.map.get(modelFingerprint.calcFingerprint());
        if (id != null) {
            this.deleting.remove(id);
            modelFingerprint.set("id", id);
        } else if (this.CACHE.contains(modelFingerprint.getStr(this.fingerprintColumnLabel))) {
            modelFingerprint.set("id", -1);
        } else {
            this.CACHE.add(modelFingerprint.getStr(this.fingerprintColumnLabel));
        }
    }

    public ModelFingerprint addFingerprint() {
        this.set("fingerprint", this.calcFingerprint());
        return this;
    }

    public void saveWithFingerprint() {
        this.addFingerprint();
        this.fingerprinter().compare(this);
        if (this.get("id") == null) {
            this.save();
        }
    }

    public void removeExpired() {
        int size = this.deleting.size();
        LOG.info("delete " + size + "records");
        if (size != 0) {
            ArrayList ids = Lists.newArrayList(this.deleting);
            int idSize = ids.size();
            int batchSize = 1000;
            int length = idSize / batchSize;
            if (idSize % batchSize != 0) {
                ++length;
            }
            for (int i = 0; i < length; ++i) {
                String sql;
                if (i == length - 1) {
                    sql = "DELETE FROM " + this.tableName() + " WHERE id IN (" + Joiner.on((String)", ").join(ids.subList(i * batchSize, ids.size()), (Object)", ", new Object[0]) + ")";
                    Db.update((String)sql);
                    continue;
                }
                sql = "DELETE FROM " + this.tableName() + " WHERE id IN (" + Joiner.on((String)", ").join(ids.subList(i * batchSize, i * batchSize + batchSize), (Object)", ", new Object[0]) + ")";
                Db.update((String)sql);
            }
        }
    }
}

