/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.config;

import com.google.common.collect.Maps;
import com.jfinal.ext.kit.ResourceKit;
import com.jfinal.ext.plugin.config.ConfigPlugin;
import com.jfinal.kit.PathKit;
import com.jfinal.log.Logger;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ConfigKit {
    protected static final Logger LOG = Logger.getLogger(ConfigKit.class);
    private static List<String> includeResources;
    private static List<String> excludeResources;
    private static Map<String, String> map;
    private static Map<String, String> testMap;
    private static Map<String, Long> lastmodifies;
    private static boolean reload;

    static void init(List<String> includeResources, List<String> excludeResources, boolean reload) {
        ConfigKit.includeResources = includeResources;
        ConfigKit.excludeResources = excludeResources;
        ConfigKit.reload = reload;
        for (final String resource : includeResources) {
            LOG.debug("include :" + resource);
            File[] propertiesFiles = null;
            for (File file : propertiesFiles = new File(PathKit.getRootClassPath()).listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return Pattern.compile(resource).matcher(pathname.getName()).matches();
                }
            })) {
                String fileName = file.getName();
                LOG.debug("fileName:" + fileName);
                if (fileName.endsWith("-test." + ConfigPlugin.suffix)) continue;
                boolean excluded = false;
                for (String exclude : excludeResources) {
                    if (!Pattern.compile(exclude).matcher(file.getName()).matches()) continue;
                    excluded = true;
                }
                if (excluded) continue;
                lastmodifies.put(fileName, new File(fileName).lastModified());
                map.putAll(ResourceKit.readProperties(fileName));
                try {
                    testMap.putAll(ResourceKit.readProperties(ConfigKit.testFileName(fileName)));
                }
                catch (IllegalArgumentException e) {
                    LOG.info(e.getMessage());
                }
            }
        }
        LOG.debug("map" + map);
        LOG.debug("testMap" + testMap);
        LOG.info("config init success!");
    }

    private static String testFileName(String fileName) {
        return fileName.substring(0, fileName.indexOf("." + ConfigPlugin.suffix)) + "-test." + ConfigPlugin.suffix;
    }

    public static String getStr(String key, String defaultVal) {
        String val;
        if (testMap == null || map == null) {
            throw new RuntimeException(" please start ConfigPlugin first~");
        }
        if (reload) {
            ConfigKit.checkFileModify();
        }
        if ((val = testMap.get(key)) == null || "".equals(val.trim())) {
            val = map.get(key);
        }
        return val == null ? defaultVal : val + "";
    }

    private static void checkFileModify() {
        Set<String> filenames = lastmodifies.keySet();
        for (String filename : filenames) {
            File file = new File(filename);
            if (lastmodifies.get(filename).longValue() == file.lastModified()) continue;
            LOG.info(filename + " changed, reload.");
            ConfigKit.init(includeResources, excludeResources, reload);
        }
    }

    public static String getStr(String key) {
        return ConfigKit.getStr(key, "");
    }

    public static long getLong(String key) {
        return ConfigKit.getLong(key, 0L);
    }

    public static long getLong(String key, long defaultVal) {
        String val = ConfigKit.getStr(key).trim();
        if ("".equals(val)) {
            return defaultVal;
        }
        return Long.parseLong(val);
    }

    public static int getInt(String key, int defaultVal) {
        String val = ConfigKit.getStr(key).trim();
        if ("".equals(val)) {
            return defaultVal;
        }
        return Integer.parseInt(val);
    }

    public static int getInt(String key) {
        return ConfigKit.getInt(key, 0);
    }

    public static void set(String key, String val) {
        throw new RuntimeException("I do not know how to do it now..");
    }

    static {
        map = Maps.newHashMap();
        testMap = Maps.newHashMap();
        lastmodifies = Maps.newHashMap();
        reload = true;
    }
}

