/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.jms;

import com.jfinal.log.Logger;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;

public class QueueProducer {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected String serverUrl;
    protected String username;
    protected String password;
    protected String queueName;
    protected int reConnectTimes;
    protected int reConnectInterval;
    private Connection connection;
    private Session session;
    private Destination destination;
    private MessageProducer producer;

    public QueueProducer(String serverUrl, String username, String password, String queueName) {
        this.serverUrl = serverUrl;
        this.username = username;
        this.password = password;
        this.queueName = queueName;
        this.initConnection();
    }

    public QueueProducer(String serverUrl, String username, String password, String queueName, int reConnectTimes, int reConnectInterval) {
        this(serverUrl, username, password, queueName);
        this.reConnectTimes = reConnectTimes;
        this.reConnectInterval = reConnectInterval;
    }

    private void initConnection() {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.serverUrl);
        try {
            this.connection = connectionFactory.createConnection(this.username, this.password);
            this.session = this.connection.createSession(false, 1);
            this.destination = this.session.createQueue(this.queueName);
            this.producer = this.session.createProducer(this.destination);
            this.producer.setDeliveryMode(1);
            this.connection.start();
        }
        catch (JMSException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void closeConnection() {
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean sendMessage(Serializable object, int msgType) {
        try {
            if (this.session == null && !this.reConnect()) {
                return false;
            }
            this.logger.debug("send message, msg_type:" + msgType);
            ObjectMessage om = this.session.createObjectMessage(object);
            om.setIntProperty("msgType", msgType);
            this.producer.send(this.destination, (Message)om);
        }
        catch (JMSException e) {
            this.logger.error("send error", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean reConnect() {
        int times = this.reConnectTimes;
        while (times-- > 0) {
            this.logger.debug("reConnectTimes" + times);
            this.initConnection();
            if (this.session != null) {
                return true;
            }
            try {
                TimeUnit.MINUTES.sleep(this.reConnectInterval);
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }
}

