/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.render.excel;

import com.google.common.collect.Maps;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class JxlsRender
extends Render {
    private static final String CONTENT_TYPE = "application/vnd.ms-excel;charset=" + JxlsRender.getEncoding();
    private Map<String, Object> beans = Maps.newHashMap();
    private String filename = "file1.xls";
    private String templetFile;

    public static JxlsRender me(String templetFile) {
        return new JxlsRender(templetFile);
    }

    public JxlsRender(String templetFile) {
        this.templetFile = templetFile;
    }

    public JxlsRender beans(Map<String, Object> beans) {
        this.beans = beans;
        return this;
    }

    private void buildBean() {
        Enumeration attrs = this.request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String key = (String)attrs.nextElement();
            Object value = this.request.getAttribute(key);
            this.beans.put(key, value);
        }
    }

    public JxlsRender filename(String filename) {
        this.filename = filename;
        return this;
    }

    public void render() {
        if (this.beans.isEmpty()) {
            this.buildBean();
        }
        this.response.setContentType(CONTENT_TYPE);
        this.response.setHeader("Content-Disposition", "attachment;Filename=" + this.filename);
        try {
            ServletOutputStream out = this.response.getOutputStream();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.templetFile));
            XLSTransformer transformer = new XLSTransformer();
            HSSFWorkbook workBook = transformer.transformXLS((InputStream)is, this.beans);
            workBook.write((OutputStream)out);
        }
        catch (Exception e) {
            throw new RenderException((Throwable)e);
        }
    }

    public JxlsRender templetFile(String templetFile) {
        this.templetFile = templetFile;
        return this;
    }
}

