/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.test;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.jfinal.config.JFinalConfig;
import com.jfinal.core.JFinal;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.ext.test.MockHttpRequest;
import com.jfinal.ext.test.MockHttpResponse;
import com.jfinal.ext.test.MockServletContext;
import com.jfinal.handler.Handler;
import com.jfinal.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import javax.servlet.ServletContext;
import org.junit.AfterClass;
import org.junit.Before;

public abstract class ControllerTestCase<T extends JFinalConfig> {
    protected static final Logger LOG = Logger.getLogger(ControllerTestCase.class);
    protected static ServletContext servletContext = new MockServletContext();
    protected static MockHttpRequest request;
    protected static MockHttpResponse response;
    protected static Handler handler;
    private static boolean configStarted;
    private static JFinalConfig configInstance;
    private String actionUrl;
    private String bodyData;
    private File bodyFile;
    private File responseFile;
    private Class<? extends JFinalConfig> config;

    private static void initConfig(Class<JFinal> clazz, JFinal me, ServletContext servletContext, JFinalConfig config) {
        Reflect.on(me).call("init", config, servletContext);
    }

    public static void start(Class<? extends JFinalConfig> configClass) throws Exception {
        if (configStarted) {
            return;
        }
        Class<JFinal> clazz = JFinal.class;
        JFinal me = JFinal.me();
        configInstance = configClass.newInstance();
        ControllerTestCase.initConfig(clazz, me, servletContext, configInstance);
        handler = (Handler)Reflect.on(me).get("handler");
        configStarted = true;
        configInstance.afterJFinalStart();
    }

    public ControllerTestCase() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        Preconditions.checkArgument((boolean)(genericSuperclass instanceof ParameterizedType), (Object)"Your ControllerTestCase must have genericType");
        this.config = (Class)((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
    }

    public Object findAttrAfterInvoke(String key) {
        return request.getAttribute(key);
    }

    private String getTarget(String url, MockHttpRequest request) {
        String target = url;
        if (url.contains("?")) {
            String[] keyVals;
            target = url.substring(0, url.indexOf("?"));
            String queryString = url.substring(url.indexOf("?") + 1);
            for (String keyVal : keyVals = queryString.split("&")) {
                int i = keyVal.indexOf(61);
                String key = keyVal.substring(0, i);
                String val = keyVal.substring(i + 1);
                request.setParameter(key, val);
            }
        }
        return target;
    }

    @Before
    public void init() throws Exception {
        ControllerTestCase.start(this.config);
    }

    @AfterClass
    public static void stop() throws Exception {
        configInstance.beforeJFinalStop();
    }

    public String invoke() {
        if (this.bodyFile != null) {
            List req = null;
            try {
                req = Files.readLines((File)this.bodyFile, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
            this.bodyData = Joiner.on((String)"").join((Iterable)req);
        }
        StringWriter resp = new StringWriter();
        request = new MockHttpRequest(this.bodyData);
        response = new MockHttpResponse(resp);
        Reflect.on(handler).call("handle", this.getTarget(this.actionUrl, request), request, response, new boolean[]{true});
        String response = resp.toString();
        if (this.responseFile != null) {
            try {
                Files.write((CharSequence)response, (File)this.responseFile, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return response;
    }

    public ControllerTestCase<T> post(File bodyFile) {
        this.bodyFile = bodyFile;
        return this;
    }

    public ControllerTestCase<T> post(String bodyData) {
        this.bodyData = bodyData;
        return this;
    }

    public ControllerTestCase<T> use(String actionUrl) {
        this.actionUrl = actionUrl;
        return this;
    }

    public ControllerTestCase<T> writeTo(File responseFile) {
        this.responseFile = responseFile;
        return this;
    }

    static {
        configStarted = false;
    }
}

