/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.zuul;

import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class ApplicationRouteLocator
implements RouteLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationRouteLocator.class);
    private AtomicReference<Map<String, ZuulProperties.ZuulRoute>> routes = new AtomicReference();
    private ApplicationRegistry registry;
    private String prefix;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private String servletPath;
    private String[] proxyEndpoints = new String[]{"/env", "/metrics", "/trace", "/dump", "/jolokia", "/info", "/configprops", "/trace", "/activiti", "/logfile", "/refresh"};

    public ApplicationRouteLocator(String servletPath, ApplicationRegistry registry, String prefix) {
        this.servletPath = servletPath;
        this.registry = registry;
        this.prefix = prefix;
    }

    private LinkedHashMap<String, ZuulProperties.ZuulRoute> locateRoutes() {
        LinkedHashMap<String, ZuulProperties.ZuulRoute> locateRoutes = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
        for (Application application : this.registry.getApplications()) {
            String appPath = this.prefix + "/" + application.getId();
            this.addRoute(locateRoutes, appPath + "/health/**", application.getHealthUrl());
            if (StringUtils.isEmpty((Object)application.getManagementUrl())) continue;
            for (String endpoint : this.proxyEndpoints) {
                this.addRoute(locateRoutes, appPath + endpoint + "/**", application.getManagementUrl() + endpoint);
            }
        }
        return locateRoutes;
    }

    private void addRoute(LinkedHashMap<String, ZuulProperties.ZuulRoute> locateRoutes, String path, String url) {
        locateRoutes.put(path, new ZuulProperties.ZuulRoute(path, url));
    }

    public ProxyRouteSpec getMatchingRoute(String path) {
        LOGGER.debug("Finding route for path: {}", (Object)path);
        LOGGER.debug("servletPath={}", (Object)this.servletPath);
        if (StringUtils.hasText((String)this.servletPath) && !this.servletPath.equals("/") && path.startsWith(this.servletPath)) {
            path = path.substring(this.servletPath.length());
        }
        for (Map.Entry<String, ZuulProperties.ZuulRoute> entry : this.routes.get().entrySet()) {
            String pattern = entry.getKey();
            LOGGER.debug("Matching pattern: {}", (Object)pattern);
            if (!this.pathMatcher.match(pattern, path)) continue;
            ZuulProperties.ZuulRoute route = entry.getValue();
            int index = route.getPath().indexOf("*") - 1;
            String routePrefix = route.getPath().substring(0, index);
            String targetPath = path.substring(index, path.length());
            return new ProxyRouteSpec(route.getId(), targetPath, route.getLocation(), routePrefix);
        }
        return null;
    }

    public Collection<String> getRoutePaths() {
        return this.getRoutes().keySet();
    }

    public void resetRoutes() {
        this.routes.set(this.locateRoutes());
    }

    public Map<String, String> getRoutes() {
        if (this.routes.get() == null) {
            this.routes.set(this.locateRoutes());
        }
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        Iterator<String> i$ = this.routes.get().keySet().iterator();
        while (i$.hasNext()) {
            String key;
            String url = key = i$.next();
            values.put(url, this.routes.get().get(key).getLocation());
        }
        return values;
    }

    public Collection<String> getIgnoredPaths() {
        return Collections.emptyList();
    }

    public void setProxyEndpoints(String[] proxyEndpoints) {
        for (String endpoint : proxyEndpoints) {
            Assert.hasText((String)endpoint, (String)"The proxyEndpoints must not contain null");
            Assert.isTrue((boolean)endpoint.startsWith("/"), (String)"All proxyEndpoints must start with '/'");
        }
        this.proxyEndpoints = (String[])proxyEndpoints.clone();
    }

    public static class ProxyRouteSpec {
        private final String id;
        private final String path;
        private final String location;
        private final String prefix;

        public ProxyRouteSpec(String id, String path, String location, String prefix) {
            this.id = id;
            this.path = path;
            this.location = location;
            this.prefix = prefix;
        }

        public String getId() {
            return this.id;
        }

        public String getPath() {
            return this.path;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

