/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.discovery;

import de.codecentric.boot.admin.discovery.ServiceInstanceConverter;
import de.codecentric.boot.admin.model.Application;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.util.StringUtils;

public class DefaultServiceInstanceConverter
implements ServiceInstanceConverter {
    private String managementContextPath = "";
    private String healthEndpointPath = "health";

    @Override
    public Application convert(ServiceInstance instance) {
        String serviceUrl = instance.getUri().toString();
        String managementUrl = this.append(serviceUrl, this.managementContextPath);
        String healthUrl = this.append(managementUrl, this.healthEndpointPath);
        return Application.create((String)instance.getServiceId()).withHealthUrl(healthUrl).withManagementUrl(managementUrl).withServiceUrl(serviceUrl).build();
    }

    protected final String append(String uri, String path) {
        String baseUri = uri.replaceFirst("/+$", "");
        if (StringUtils.isEmpty((Object)path)) {
            return baseUri;
        }
        String normPath = path.replaceFirst("^/+", "").replaceFirst("/+$", "");
        return baseUri + "/" + normPath;
    }

    public void setManagementContextPath(String managementContextPath) {
        this.managementContextPath = managementContextPath;
    }

    public void setHealthEndpointPath(String healthEndpointPath) {
        this.healthEndpointPath = healthEndpointPath;
    }
}

