/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import de.codecentric.boot.admin.notify.Notifier;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatusChangeNotifier
implements Notifier {
    protected String[] ignoreChanges = new String[]{"UNKNOWN:UP"};
    private boolean enabled = true;

    @Override
    public void notify(ClientApplicationEvent event) {
        if (event instanceof ClientApplicationStatusChangedEvent) {
            ClientApplicationStatusChangedEvent statusChange = (ClientApplicationStatusChangedEvent)event;
            if (this.enabled && this.shouldNotify(statusChange.getFrom().getStatus(), statusChange.getTo().getStatus())) {
                try {
                    this.doNotify(statusChange);
                }
                catch (Exception ex) {
                    this.getLogger().error("Couldn't notify for status change {} ", (Object)statusChange, (Object)ex);
                }
            }
        }
    }

    protected boolean shouldNotify(String from, String to) {
        return Arrays.binarySearch(this.ignoreChanges, from + ":" + to) < 0 && Arrays.binarySearch(this.ignoreChanges, "*:" + to) < 0 && Arrays.binarySearch(this.ignoreChanges, from + ":*") < 0;
    }

    protected abstract void doNotify(ClientApplicationStatusChangedEvent var1) throws Exception;

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public void setIgnoreChanges(String[] ignoreChanges) {
        Object[] copy = Arrays.copyOf(ignoreChanges, ignoreChanges.length);
        Arrays.sort(copy);
        this.ignoreChanges = copy;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

