/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.TimeWindowHistogram;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.micrometer.core.lang.Nullable;

public abstract class AbstractDistributionSummary
extends AbstractMeter
implements DistributionSummary {
    private final TimeWindowHistogram histogram;
    private final DistributionStatisticConfig distributionStatisticConfig;
    private final double scale;

    protected AbstractDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        super(id);
        this.histogram = new TimeWindowHistogram(clock, distributionStatisticConfig);
        this.distributionStatisticConfig = distributionStatisticConfig;
        this.scale = scale;
    }

    @Override
    public final void record(double amount) {
        if (amount >= 0.0) {
            this.histogram.recordDouble(this.scale * amount);
            this.recordNonNegative(this.scale * amount);
        }
    }

    protected abstract void recordNonNegative(double var1);

    @Override
    public double percentile(double percentile) {
        return this.histogram.percentile(percentile);
    }

    @Override
    public double histogramCountAtValue(long value) {
        return this.histogram.histogramCountAtValue(value);
    }

    @Override
    public HistogramSnapshot takeSnapshot(boolean supportsAggregablePercentiles) {
        return this.histogram.takeSnapshot(this.count(), this.totalAmount(), this.max(), supportsAggregablePercentiles);
    }

    public boolean equals(@Nullable Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }

    public DistributionStatisticConfig statsConfig() {
        return this.distributionStatisticConfig;
    }
}

