/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Producer;
import rx.Subscriber;

public final class SingleDelayedProducer<T>
extends AtomicInteger
implements Producer {
    private static final long serialVersionUID = 4721551710164477552L;
    final Subscriber<? super T> child;
    T value;
    static final int REQUESTED = 1;
    static final int SET = 2;

    public SingleDelayedProducer(Subscriber<? super T> child) {
        this.child = child;
    }

    @Override
    public void request(long n) {
        if (n > 0L) {
            int s;
            while (((s = this.get()) & 1) == 0) {
                int u = s | 1;
                if (!this.compareAndSet(s, u)) continue;
                if ((s & 2) == 0) break;
                this.emit();
                break;
            }
        }
    }

    public void set(T value) {
        int s;
        while (((s = this.get()) & 2) == 0) {
            int u = s | 2;
            this.value = value;
            if (!this.compareAndSet(s, u)) continue;
            if ((s & 1) == 0) break;
            this.emit();
            break;
        }
    }

    void emit() {
        try {
            T v = this.value;
            this.value = null;
            if (this.child.isUnsubscribed()) {
                return;
            }
            this.child.onNext(v);
        }
        catch (Throwable t) {
            this.child.onError(t);
            return;
        }
        this.child.onCompleted();
    }
}

