/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import zipkin.Codec;
import zipkin.internal.V2StorageComponent;
import zipkin.internal.v2.Call;
import zipkin.internal.v2.codec.BytesEncoder;
import zipkin.internal.v2.storage.QueryRequest;
import zipkin.storage.StorageComponent;

@RestController
@RequestMapping(value={"/api/v2"})
@CrossOrigin(value={"${zipkin.query.allowed-origins:*}"})
@ConditionalOnProperty(name={"zipkin.query.enabled"}, matchIfMissing=true)
public class ZipkinQueryApiV2 {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    final String storageType;
    final V2StorageComponent storage;
    final long defaultLookback;
    final int namesMaxAge;
    volatile int serviceCount;

    ZipkinQueryApiV2(StorageComponent storage, @Value(value="${zipkin.storage.type:mem}") String storageType, @Value(value="${zipkin.query.lookback:86400000}") long defaultLookback, @Value(value="${zipkin.query.names-max-age:300}") int namesMaxAge) {
        this.storage = storage instanceof V2StorageComponent ? (V2StorageComponent)storage : null;
        this.storageType = storageType;
        this.defaultLookback = defaultLookback;
        this.namesMaxAge = namesMaxAge;
    }

    @RequestMapping(value={"/dependencies"}, method={RequestMethod.GET}, produces={"application/json"})
    public byte[] getDependencies(@RequestParam(value="endTs", required=true) long endTs, @Nullable @RequestParam(value="lookback", required=false) Long lookback) throws IOException {
        if (this.storage == null) {
            throw new Version2StorageNotConfigured();
        }
        Call call = this.storage.v2SpanStore().getDependencies(endTs, lookback != null ? lookback : this.defaultLookback);
        return Codec.JSON.writeDependencyLinks((List)call.execute());
    }

    @RequestMapping(value={"/services"}, method={RequestMethod.GET})
    public ResponseEntity<List<String>> getServiceNames() throws IOException {
        if (this.storage == null) {
            throw new Version2StorageNotConfigured();
        }
        List serviceNames = (List)this.storage.v2SpanStore().getServiceNames().execute();
        this.serviceCount = serviceNames.size();
        return this.maybeCacheNames(serviceNames);
    }

    @RequestMapping(value={"/spans"}, method={RequestMethod.GET})
    public ResponseEntity<List<String>> getSpanNames(@RequestParam(value="serviceName", required=true) String serviceName) throws IOException {
        if (this.storage == null) {
            throw new Version2StorageNotConfigured();
        }
        return this.maybeCacheNames((List)this.storage.v2SpanStore().getSpanNames(serviceName).execute());
    }

    @RequestMapping(value={"/traces"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getTraces(@Nullable @RequestParam(value="serviceName", required=false) String serviceName, @Nullable @RequestParam(value="spanName", required=false) String spanName, @Nullable @RequestParam(value="annotationQuery", required=false) String annotationQuery, @Nullable @RequestParam(value="minDuration", required=false) Long minDuration, @Nullable @RequestParam(value="maxDuration", required=false) Long maxDuration, @Nullable @RequestParam(value="endTs", required=false) Long endTs, @Nullable @RequestParam(value="lookback", required=false) Long lookback, @RequestParam(value="limit", defaultValue="10") int limit) throws IOException {
        if (this.storage == null) {
            throw new Version2StorageNotConfigured();
        }
        QueryRequest queryRequest = QueryRequest.newBuilder().serviceName(serviceName).spanName(spanName).parseAnnotationQuery(annotationQuery).minDuration(minDuration).maxDuration(maxDuration).endTs(endTs != null ? endTs : System.currentTimeMillis()).lookback(lookback != null ? lookback : this.defaultLookback).limit(limit).build();
        List traces = (List)this.storage.v2SpanStore().getTraces(queryRequest).execute();
        return new String(BytesEncoder.JSON.encodeNestedList(traces), UTF_8);
    }

    @RequestMapping(value={"/trace/{traceIdHex}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getTrace(@PathVariable String traceIdHex, WebRequest request) throws IOException {
        if (this.storage == null) {
            throw new Version2StorageNotConfigured();
        }
        List trace = (List)this.storage.v2SpanStore().getTrace(traceIdHex).execute();
        if (trace.isEmpty()) {
            throw new TraceNotFoundException(traceIdHex);
        }
        return new String(BytesEncoder.JSON.encodeList(trace), UTF_8);
    }

    @ExceptionHandler(value={Version2StorageNotConfigured.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void version2StorageNotConfigured() {
    }

    @ExceptionHandler(value={TraceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void notFound() {
    }

    ResponseEntity<List<String>> maybeCacheNames(List<String> names) {
        ResponseEntity.BodyBuilder response = ResponseEntity.ok();
        if (this.serviceCount > 3) {
            response.cacheControl(CacheControl.maxAge((long)this.namesMaxAge, (TimeUnit)TimeUnit.SECONDS).mustRevalidate());
        }
        return response.body(names);
    }

    static class TraceNotFoundException
    extends RuntimeException {
        TraceNotFoundException(String traceIdHex) {
            super("Cannot find trace " + traceIdHex);
        }
    }

    class Version2StorageNotConfigured
    extends RuntimeException {
        Version2StorageNotConfigured() {
            super("Api version 2 not yet supported for " + ZipkinQueryApiV2.this.storageType);
        }
    }
}

