/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.brave;

import com.github.kristofa.brave.Brave;
import java.util.List;
import javax.annotation.Nullable;
import zipkin.Span;
import zipkin.storage.AsyncSpanConsumer;
import zipkin.storage.Callback;

final class TracedAsyncSpanConsumer
implements AsyncSpanConsumer {
    private final Brave brave;
    private final AsyncSpanConsumer delegate;
    private final String component;

    TracedAsyncSpanConsumer(Brave brave, AsyncSpanConsumer delegate) {
        this.brave = brave;
        this.delegate = delegate;
        this.component = delegate.getClass().getSimpleName();
    }

    public void accept(List<Span> spans, final Callback<Void> callback) {
        if (this.brave.serverSpanThreadBinder().getCurrentServerSpan() == null || this.brave.serverSpanThreadBinder().getCurrentServerSpan().getSpan() == null) {
            this.delegate.accept(spans, callback);
            return;
        }
        this.brave.localTracer().startNewSpan(this.component, "accept");
        this.delegate.accept(spans, (Callback)new Callback<Void>(){

            public void onSuccess(@Nullable Void value) {
                TracedAsyncSpanConsumer.this.brave.localTracer().finishSpan();
                callback.onSuccess((Object)value);
            }

            public void onError(Throwable t) {
                TracedAsyncSpanConsumer.this.brave.localTracer().finishSpan();
                callback.onError(t);
            }
        });
    }
}

