/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor;

import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.activiti.engine.impl.asyncexecutor.AcquireAsyncJobsDueRunnable;
import org.activiti.engine.impl.asyncexecutor.AcquireTimerJobsRunnable;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.asyncexecutor.ExecuteAsyncRunnable;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncJobExecutor
implements AsyncExecutor {
    private static Logger log = LoggerFactory.getLogger(DefaultAsyncJobExecutor.class);
    protected int corePoolSize = 2;
    protected int maxPoolSize = 10;
    protected long keepAliveTime = 5000L;
    protected int queueSize = 100;
    protected BlockingQueue<Runnable> threadPoolQueue;
    protected ExecutorService executorService;
    protected long secondsToWaitOnShutdown = 60L;
    protected Thread timerJobAcquisitionThread;
    protected Thread asyncJobAcquisitionThread;
    protected AcquireTimerJobsRunnable timerJobRunnable;
    protected AcquireAsyncJobsDueRunnable asyncJobsDueRunnable;
    protected boolean isAutoActivate = false;
    protected boolean isActive = false;
    protected int maxTimerJobsPerAcquisition = 1;
    protected int maxAsyncJobsDuePerAcquisition = 1;
    protected int defaultTimerJobAcquireWaitTimeInMillis = 10000;
    protected int defaultAsyncJobAcquireWaitTimeInMillis = 10000;
    protected String lockOwner = UUID.randomUUID().toString();
    protected int timerLockTimeInMillis = 300000;
    protected int asyncJobLockTimeInMillis = 300000;
    protected int retryWaitTimeInMillis = 500;
    protected LinkedList<JobEntity> temporaryJobQueue = new LinkedList();
    protected CommandExecutor commandExecutor;

    @Override
    public void executeAsyncJob(JobEntity job) {
        if (this.isActive) {
            this.executorService.execute(new ExecuteAsyncRunnable(job, this.commandExecutor));
        } else {
            this.temporaryJobQueue.add(job);
        }
    }

    @Override
    public void start() {
        if (this.isActive) {
            return;
        }
        log.info("Starting up the default async job executor [{}].", (Object)this.getClass().getName());
        if (this.timerJobRunnable == null) {
            this.timerJobRunnable = new AcquireTimerJobsRunnable(this);
        }
        if (this.asyncJobsDueRunnable == null) {
            this.asyncJobsDueRunnable = new AcquireAsyncJobsDueRunnable(this);
        }
        this.startExecutingAsyncJobs();
        this.isActive = true;
        while (!this.temporaryJobQueue.isEmpty()) {
            JobEntity job = this.temporaryJobQueue.pop();
            this.executeAsyncJob(job);
        }
        this.isActive = true;
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isActive) {
            return;
        }
        log.info("Shutting down the default async job executor [{}].", (Object)this.getClass().getName());
        this.timerJobRunnable.stop();
        this.asyncJobsDueRunnable.stop();
        this.stopExecutingAsyncJobs();
        this.timerJobRunnable = null;
        this.asyncJobsDueRunnable = null;
        this.isActive = false;
    }

    protected void startExecutingAsyncJobs() {
        if (this.threadPoolQueue == null) {
            log.info("Creating thread pool queue of size {}", (Object)this.queueSize);
            this.threadPoolQueue = new ArrayBlockingQueue<Runnable>(this.queueSize);
        }
        if (this.executorService == null) {
            log.info("Creating executor service with corePoolSize {}, maxPoolSize {} and keepAliveTime {}", new Object[]{this.corePoolSize, this.maxPoolSize, this.keepAliveTime});
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, this.threadPoolQueue);
            threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            this.executorService = threadPoolExecutor;
        }
        this.startJobAcquisitionThread();
    }

    protected void stopExecutingAsyncJobs() {
        this.stopJobAcquisitionThread();
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(this.secondsToWaitOnShutdown, TimeUnit.SECONDS)) {
                log.warn("Timeout during shutdown of async job executor. The current running jobs could not end within " + this.secondsToWaitOnShutdown + " seconds after shutdown operation.");
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while shutting down the async job executor. ", (Throwable)e);
        }
        this.executorService = null;
    }

    protected void startJobAcquisitionThread() {
        if (this.timerJobAcquisitionThread == null) {
            this.timerJobAcquisitionThread = new Thread(this.timerJobRunnable);
        }
        this.timerJobAcquisitionThread.start();
        if (this.asyncJobAcquisitionThread == null) {
            this.asyncJobAcquisitionThread = new Thread(this.asyncJobsDueRunnable);
        }
        this.asyncJobAcquisitionThread.start();
    }

    protected void stopJobAcquisitionThread() {
        try {
            this.timerJobAcquisitionThread.join();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for the timer job acquisition thread to terminate", (Throwable)e);
        }
        try {
            this.asyncJobAcquisitionThread.join();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for the async job acquisition thread to terminate", (Throwable)e);
        }
        this.timerJobAcquisitionThread = null;
        this.asyncJobAcquisitionThread = null;
    }

    @Override
    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    @Override
    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public boolean isAutoActivate() {
        return this.isAutoActivate;
    }

    @Override
    public void setAutoActivate(boolean isAutoActivate) {
        this.isAutoActivate = isAutoActivate;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public long getSecondsToWaitOnShutdown() {
        return this.secondsToWaitOnShutdown;
    }

    public void setSecondsToWaitOnShutdown(long secondsToWaitOnShutdown) {
        this.secondsToWaitOnShutdown = secondsToWaitOnShutdown;
    }

    public BlockingQueue<Runnable> getThreadPoolQueue() {
        return this.threadPoolQueue;
    }

    public void setThreadPoolQueue(BlockingQueue<Runnable> threadPoolQueue) {
        this.threadPoolQueue = threadPoolQueue;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    @Override
    public int getTimerLockTimeInMillis() {
        return this.timerLockTimeInMillis;
    }

    @Override
    public void setTimerLockTimeInMillis(int timerLockTimeInMillis) {
        this.timerLockTimeInMillis = timerLockTimeInMillis;
    }

    @Override
    public int getAsyncJobLockTimeInMillis() {
        return this.asyncJobLockTimeInMillis;
    }

    @Override
    public void setAsyncJobLockTimeInMillis(int asyncJobLockTimeInMillis) {
        this.asyncJobLockTimeInMillis = asyncJobLockTimeInMillis;
    }

    @Override
    public int getMaxTimerJobsPerAcquisition() {
        return this.maxTimerJobsPerAcquisition;
    }

    @Override
    public void setMaxTimerJobsPerAcquisition(int maxTimerJobsPerAcquisition) {
        this.maxTimerJobsPerAcquisition = maxTimerJobsPerAcquisition;
    }

    @Override
    public int getMaxAsyncJobsDuePerAcquisition() {
        return this.maxAsyncJobsDuePerAcquisition;
    }

    @Override
    public void setMaxAsyncJobsDuePerAcquisition(int maxAsyncJobsDuePerAcquisition) {
        this.maxAsyncJobsDuePerAcquisition = maxAsyncJobsDuePerAcquisition;
    }

    @Override
    public int getDefaultTimerJobAcquireWaitTimeInMillis() {
        return this.defaultTimerJobAcquireWaitTimeInMillis;
    }

    @Override
    public void setDefaultTimerJobAcquireWaitTimeInMillis(int defaultTimerJobAcquireWaitTimeInMillis) {
        this.defaultTimerJobAcquireWaitTimeInMillis = defaultTimerJobAcquireWaitTimeInMillis;
    }

    @Override
    public int getDefaultAsyncJobAcquireWaitTimeInMillis() {
        return this.defaultAsyncJobAcquireWaitTimeInMillis;
    }

    @Override
    public void setDefaultAsyncJobAcquireWaitTimeInMillis(int defaultAsyncJobAcquireWaitTimeInMillis) {
        this.defaultAsyncJobAcquireWaitTimeInMillis = defaultAsyncJobAcquireWaitTimeInMillis;
    }

    public void setTimerJobRunnable(AcquireTimerJobsRunnable timerJobRunnable) {
        this.timerJobRunnable = timerJobRunnable;
    }

    public void setAsyncJobsDueRunnable(AcquireAsyncJobsDueRunnable asyncJobsDueRunnable) {
        this.asyncJobsDueRunnable = asyncJobsDueRunnable;
    }

    @Override
    public int getRetryWaitTimeInMillis() {
        return this.retryWaitTimeInMillis;
    }

    @Override
    public void setRetryWaitTimeInMillis(int retryWaitTimeInMillis) {
        this.retryWaitTimeInMillis = retryWaitTimeInMillis;
    }
}

