/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import org.activiti.engine.history.HistoricFormProperty;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricDetailEntity;

public class HistoricFormPropertyEntity
extends HistoricDetailEntity
implements HistoricFormProperty {
    private static final long serialVersionUID = 1L;
    protected String propertyId;
    protected String propertyValue;

    public HistoricFormPropertyEntity() {
        this.detailType = "FormProperty";
    }

    public HistoricFormPropertyEntity(ExecutionEntity execution, String propertyId, String propertyValue) {
        this(execution, propertyId, propertyValue, null);
    }

    public HistoricFormPropertyEntity(ExecutionEntity execution, String propertyId, String propertyValue, String taskId) {
        this.processInstanceId = execution.getProcessInstanceId();
        this.executionId = execution.getId();
        this.taskId = taskId;
        this.propertyId = propertyId;
        this.propertyValue = propertyValue;
        this.time = Context.getProcessEngineConfiguration().getClock().getCurrentTime();
        this.detailType = "FormProperty";
        HistoricActivityInstanceEntity historicActivityInstance = Context.getCommandContext().getHistoryManager().findActivityInstance(execution);
        if (historicActivityInstance != null) {
            this.activityInstanceId = historicActivityInstance.getId();
        }
    }

    @Override
    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    @Override
    public String getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }
}

