/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.google.common.base.Preconditions;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hadoop.hbase.rest.Constants;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.RESTServletContainer;
import org.apache.hadoop.hbase.rest.ResourceConfig;
import org.apache.hadoop.hbase.rest.filter.AuthFilter;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.HttpServerUtil;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.net.DNS;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class RESTServer
implements Constants {
    private static void printUsageAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("bin/hbase rest start", "", options, "\nTo run the REST server as a daemon, execute bin/hbase-daemon.sh start|stop rest [--infoport <port>] [-p <port>] [-ro]\n", true);
        System.exit(exitCode);
    }

    public static void main(String[] args) throws Exception {
        String[] filterClasses;
        String command;
        List remainingArgs;
        String val;
        Log LOG = LogFactory.getLog((String)"RESTServer");
        VersionInfo.logVersion();
        FilterHolder authFilter = null;
        Configuration conf = HBaseConfiguration.create();
        Class<ServletContainer> containerClass = ServletContainer.class;
        UserProvider userProvider = UserProvider.instantiate((Configuration)conf);
        if (userProvider.isHadoopSecurityEnabled() && userProvider.isHBaseSecurityEnabled()) {
            String machineName = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("hbase.rest.dns.interface", "default"), (String)conf.get("hbase.rest.dns.nameserver", "default")));
            String keytabFilename = conf.get("hbase.rest.keytab.file");
            Preconditions.checkArgument((keytabFilename != null && !keytabFilename.isEmpty() ? 1 : 0) != 0, (Object)"hbase.rest.keytab.file should be set if security is enabled");
            String principalConfig = conf.get("hbase.rest.kerberos.principal");
            Preconditions.checkArgument((principalConfig != null && !principalConfig.isEmpty() ? 1 : 0) != 0, (Object)"hbase.rest.kerberos.principal should be set if security is enabled");
            userProvider.login("hbase.rest.keytab.file", "hbase.rest.kerberos.principal", machineName);
            if (conf.get("hbase.rest.authentication.type") != null) {
                containerClass = RESTServletContainer.class;
                authFilter = new FilterHolder();
                authFilter.setClassName(AuthFilter.class.getName());
                authFilter.setName("AuthenticationFilter");
            }
        }
        RESTServlet servlet = RESTServlet.getInstance(conf, userProvider);
        Options options = new Options();
        options.addOption("p", "port", true, "Port to bind to [default: 8080]");
        options.addOption("ro", "readonly", false, "Respond only to GET HTTP method requests [default: false]");
        options.addOption(null, "infoport", true, "Port for web UI");
        CommandLine commandLine = null;
        try {
            commandLine = new PosixParser().parse(options, args);
        }
        catch (ParseException e) {
            LOG.error((Object)"Could not parse: ", (Throwable)e);
            RESTServer.printUsageAndExit(options, -1);
        }
        if (commandLine != null && commandLine.hasOption("port")) {
            val = commandLine.getOptionValue("port");
            servlet.getConfiguration().setInt("hbase.rest.port", Integer.valueOf(val).intValue());
            LOG.debug((Object)("port set to " + val));
        }
        if (commandLine != null && commandLine.hasOption("readonly")) {
            servlet.getConfiguration().setBoolean("hbase.rest.readonly", true);
            LOG.debug((Object)"readonly set to true");
        }
        if (commandLine != null && commandLine.hasOption("infoport")) {
            val = commandLine.getOptionValue("infoport");
            servlet.getConfiguration().setInt("hbase.rest.info.port", Integer.valueOf(val).intValue());
            LOG.debug((Object)("Web UI port set to " + val));
        }
        List list = remainingArgs = commandLine != null ? commandLine.getArgList() : new ArrayList();
        if (remainingArgs.size() != 1) {
            RESTServer.printUsageAndExit(options, 1);
        }
        if (!"start".equals(command = (String)remainingArgs.get(0))) {
            if ("stop".equals(command)) {
                System.exit(1);
            } else {
                RESTServer.printUsageAndExit(options, 1);
            }
        }
        ServletHolder sh = new ServletHolder(containerClass);
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", ResourceConfig.class.getCanonicalName());
        sh.setInitParameter("com.sun.jersey.config.property.packages", "jetty");
        ServletHolder shPojoMap = new ServletHolder(containerClass);
        Map shInitMap = sh.getInitParameters();
        for (Map.Entry e : shInitMap.entrySet()) {
            shPojoMap.setInitParameter((String)e.getKey(), (String)e.getValue());
        }
        shPojoMap.setInitParameter("com.sun.jersey.api.json.POJOMappingFeature", "true");
        Server server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        if (conf.getBoolean("hbase.rest.ssl.enabled", false)) {
            SslSelectChannelConnector sslConnector = new SslSelectChannelConnector();
            String keystore = conf.get("hbase.rest.ssl.keystore.store");
            String password = HBaseConfiguration.getPassword((Configuration)conf, (String)"hbase.rest.ssl.keystore.password", null);
            String keyPassword = HBaseConfiguration.getPassword((Configuration)conf, (String)"hbase.rest.ssl.keystore.keypassword", (String)password);
            sslConnector.setKeystore(keystore);
            sslConnector.setPassword(password);
            sslConnector.setKeyPassword(keyPassword);
            connector = sslConnector;
        }
        connector.setPort(servlet.getConfiguration().getInt("hbase.rest.port", 8080));
        connector.setHost(servlet.getConfiguration().get("hbase.rest.host", "0.0.0.0"));
        server.addConnector((Connector)connector);
        int maxThreads = servlet.getConfiguration().getInt("hbase.rest.threads.max", 100);
        int minThreads = servlet.getConfiguration().getInt("hbase.rest.threads.min", 2);
        QueuedThreadPool threadPool = new QueuedThreadPool(maxThreads);
        threadPool.setMinThreads(minThreads);
        server.setThreadPool((ThreadPool)threadPool);
        server.setSendServerVersion(false);
        server.setSendDateHeader(false);
        server.setStopAtShutdown(true);
        Context context = new Context((HandlerContainer)server, "/", 1);
        context.addServlet(shPojoMap, "/status/cluster");
        context.addServlet(sh, "/*");
        if (authFilter != null) {
            context.addFilter(authFilter, "/*", 1);
        }
        for (String filter : filterClasses = servlet.getConfiguration().getStrings("hbase.rest.filter.classes", ArrayUtils.EMPTY_STRING_ARRAY)) {
            filter = filter.trim();
            context.addFilter(Class.forName(filter), "/*", 0);
        }
        HttpServerUtil.constrainHttpMethods((Context)context);
        int port = conf.getInt("hbase.rest.info.port", 8085);
        if (port >= 0) {
            conf.setLong("startcode", System.currentTimeMillis());
            String a = conf.get("hbase.rest.info.bindAddress", "0.0.0.0");
            InfoServer infoServer = new InfoServer("rest", a, port, false, conf);
            infoServer.setAttribute("hbase.conf", (Object)conf);
            infoServer.start();
        }
        server.start();
        server.join();
    }
}

