/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Response {
    private int code;
    private Header[] headers;
    private byte[] body;
    private InputStream stream;

    public Response(int code) {
        this(code, null, null);
    }

    public Response(int code, Header[] headers) {
        this(code, headers, null);
    }

    public Response(int code, Header[] headers, byte[] body) {
        this.code = code;
        this.headers = headers;
        this.body = body;
    }

    public Response(int code, Header[] headers, byte[] body, InputStream in) {
        this.code = code;
        this.headers = headers;
        this.body = body;
        this.stream = in;
    }

    public int getCode() {
        return this.code;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public String getHeader(String key) {
        for (Header header : this.headers) {
            if (!header.getName().equalsIgnoreCase(key)) continue;
            return header.getValue();
        }
        return null;
    }

    public String getLocation() {
        return this.getHeader("Location");
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setHeaders(Header[] headers) {
        this.headers = headers;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }
}

