/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.concurrent.TimeUnit;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogManager$$anonfun$loadLogs$1$;
import kafka.log.LogSegment;
import kafka.server.OffsetCheckpoint;
import kafka.utils.FileLock;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001\u0002\u0005\f\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0011\"a\u0002'pO\u001eLgn\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003\u001dawn\u001a#jeN,\u0012a\b\t\u0004/\u0001\u0012\u0013BA\u0011\u0019\u0005\u0015\t%O]1z!\t\u0019c%D\u0001%\u0015\t)C\"\u0001\u0002j_&\u0011q\u0005\n\u0002\u0005\r&dW\r\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003 \u0003!awn\u001a#jeN\u0004\u0003\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011\u0001\u0017\u0002\u0019Q|\u0007/[2D_:4\u0017nZ:\u0016\u00035\u0002BAL\u00194u5\tqF\u0003\u000211\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Iz#aA'baB\u0011Ag\u000e\b\u0003/UJ!A\u000e\r\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003ma\u0001\"a\u000f\u001f\u000e\u0003\tI!!\u0010\u0002\u0003\u00131{wmQ8oM&<\u0007\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u001bQ|\u0007/[2D_:4\u0017nZ:!\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0015!\u00043fM\u0006,H\u000e^\"p]\u001aLw-F\u0001;\u0011!!\u0005A!A!\u0002\u0013Q\u0014A\u00043fM\u0006,H\u000e^\"p]\u001aLw\r\t\u0005\t\r\u0002\u0011)\u0019!C\u0001\u000f\u0006i1\r\\3b]\u0016\u00148i\u001c8gS\u001e,\u0012\u0001\u0013\t\u0003w%K!A\u0013\u0002\u0003\u001b\rcW-\u00198fe\u000e{gNZ5h\u0011!a\u0005A!A!\u0002\u0013A\u0015AD2mK\u0006tWM]\"p]\u001aLw\r\t\u0005\t\u001d\u0002\u0011)\u0019!C\u0001\u001f\u0006aa\r\\;tQ\u000eCWmY6NgV\t\u0001\u000b\u0005\u0002\u0018#&\u0011!\u000b\u0007\u0002\u0005\u0019>tw\r\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003Q\u000351G.^:i\u0007\",7m['tA!Aa\u000b\u0001BC\u0002\u0013\u0005q*A\tgYV\u001c\bn\u00115fG.\u0004x.\u001b8u\u001bND\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I\u0001U\u0001\u0013M2,8\u000f[\"iK\u000e\\\u0007o\\5oi6\u001b\b\u0005\u0003\u0005[\u0001\t\u0015\r\u0011\"\u0001P\u0003A\u0011X\r^3oi&|gn\u00115fG.l5\u000f\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003Q\u0003E\u0011X\r^3oi&|gn\u00115fG.l5\u000f\t\u0005\t=\u0002\u0011\t\u0011)A\u0005?\u0006I1o\u00195fIVdWM\u001d\t\u0003#\u0001L!!\u0019\n\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\b\u0002C2\u0001\u0005\u000b\u0007I\u0011\u00023\u0002\tQLW.Z\u000b\u0002KB\u0011\u0011CZ\u0005\u0003OJ\u0011A\u0001V5nK\"A\u0011\u000e\u0001B\u0001B\u0003%Q-A\u0003uS6,\u0007\u0005C\u0003l\u0001\u0011\u0005A.\u0001\u0004=S:LGO\u0010\u000b\u000b[:|\u0007/\u001d:tiV4\bCA\u001e\u0001\u0011\u0015i\"\u000e1\u0001 \u0011\u0015Y#\u000e1\u0001.\u0011\u0015\t%\u000e1\u0001;\u0011\u00151%\u000e1\u0001I\u0011\u0015q%\u000e1\u0001Q\u0011\u00151&\u000e1\u0001Q\u0011\u0015Q&\u000e1\u0001Q\u0011\u0015q&\u000e1\u0001`\u0011\u0015\u0019'\u000e1\u0001f\u0011\u001dA\bA1A\u0005\u0002e\f1DU3d_Z,'/\u001f)pS:$8\t[3dWB|\u0017N\u001c;GS2,W#\u0001>\u0011\u0005%Y\u0018B\u0001\u001d\u000b\u0011\u0019i\b\u0001)A\u0005u\u0006a\"+Z2pm\u0016\u0014\u0018\u0010U8j]R\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016\u0004\u0003bB@\u0001\u0005\u0004%\t!_\u0001\t\u0019>\u001c7NR5mK\"9\u00111\u0001\u0001!\u0002\u0013Q\u0018!\u0003'pG.4\u0015\u000e\\3!\u0011%\t9\u0001\u0001b\u0001\n\u0003\tI!\u0001\nJ]&$\u0018.\u00197UCN\\G)\u001a7bs6\u001bXCAA\u0006!\r9\u0012QB\u0005\u0004\u0003\u001fA\"aA%oi\"A\u00111\u0003\u0001!\u0002\u0013\tY!A\nJ]&$\u0018.\u00197UCN\\G)\u001a7bs6\u001b\b\u0005C\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003\u0002\u001a\u0005IBn\\4De\u0016\fG/[8o\u001fJ$U\r\\3uS>tGj\\2l+\u0005A\u0001bBA\u000f\u0001\u0001\u0006I\u0001C\u0001\u001bY><7I]3bi&|gn\u0014:EK2,G/[8o\u0019>\u001c7\u000e\t\u0005\n\u0003C\u0001!\u0019!C\u0005\u0003G\tA\u0001\\8hgV\u0011\u0011Q\u0005\t\b#\u0005\u001d\u00121FA\u001c\u0013\r\tIC\u0005\u0002\u0005!>|G\u000e\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t\u0004B\u0001\u0007G>lWn\u001c8\n\t\u0005U\u0012q\u0006\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007cA\u001e\u0002:%\u0019\u00111\b\u0002\u0003\u00071{w\r\u0003\u0005\u0002@\u0001\u0001\u000b\u0011BA\u0013\u0003\u0015awnZ:!\u0011%\t\u0019\u0005\u0001b\u0001\n\u0013\t)%\u0001\u0005eSJdunY6t+\t\t9\u0005E\u0003/\u0003\u0013\ni%C\u0002\u0002L=\u00121aU3r!\r\t\u0012qJ\u0005\u0004\u0003#\u0012\"\u0001\u0003$jY\u0016dunY6\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u000f\n\u0011\u0002Z5s\u0019>\u001c7n\u001d\u0011\t\u0013\u0005e\u0003A1A\u0005\n\u0005m\u0013\u0001\u0007:fG>4XM]=Q_&tGo\u00115fG.\u0004x.\u001b8ugV\u0011\u0011Q\f\t\b\u0003?\n)GIA4\u001b\t\t\tGC\u0002\u0002d=\n\u0011\"[7nkR\f'\r\\3\n\u0007I\n\t\u0007\u0005\u0003\u0002j\u0005=TBAA6\u0015\r\ti\u0007B\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005E\u00141\u000e\u0002\u0011\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]RD\u0001\"!\u001e\u0001A\u0003%\u0011QL\u0001\u001ae\u0016\u001cwN^3ssB{\u0017N\u001c;DQ\u0016\u001c7\u000e]8j]R\u001c\b\u0005C\u0005\u0002z\u0001\u0011\r\u0011\"\u0003\u0002|\u000591\r\\3b]\u0016\u0014XCAA?!\rY\u0014qP\u0005\u0004\u0003\u0003\u0013!A\u0003'pO\u000ecW-\u00198fe\"A\u0011Q\u0011\u0001!\u0002\u0013\ti(\u0001\u0005dY\u0016\fg.\u001a:!\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017\u000b\u0001d\u0019:fCR,\u0017I\u001c3WC2LG-\u0019;f\u0019><G)\u001b:t)\u0011\ti)a%\u0011\u0007]\ty)C\u0002\u0002\u0012b\u0011A!\u00168ji\"A\u0011QSAD\u0001\u0004\t9*\u0001\u0003eSJ\u001c\b\u0003\u0002\u0018\u0002J\tBq!a'\u0001\t\u0013\ti*A\u0006m_\u000e\\Gj\\4ESJ\u001cH\u0003BA$\u0003?C\u0001\"!&\u0002\u001a\u0002\u0007\u0011q\u0013\u0005\b\u0003G\u0003A\u0011BAS\u0003!aw.\u00193M_\u001e\u001cH\u0003BAG\u0003OC\u0001\"!&\u0002\"\u0002\u0007\u0011q\u0013\u0005\b\u0003W\u0003A\u0011AAW\u0003\u001d\u0019H/\u0019:ukB$\"!!$\t\u000f\u0005E\u0006\u0001\"\u0001\u0002.\u0006A1\u000f[;uI><h\u000eC\u0004\u00026\u0002!\t!a.\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000e\u0006\u0003\u0002\u000e\u0006e\u0006\u0002CA^\u0003g\u0003\r!!0\u0002'A\f'\u000f^5uS>t\u0017I\u001c3PM\u001a\u001cX\r^:\u0011\u000b9\n\u00141\u0006)\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002D\u00069BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0007\u0003\u001b\u000b)-!3\t\u0011\u0005\u001d\u0017q\u0018a\u0001\u0003W\t\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u001d\tY-a0A\u0002A\u000b\u0011B\\3x\u001f\u001a47/\u001a;\t\u000f\u0005=\u0007\u0001\"\u0001\u0002.\u0006q2\r[3dWB|\u0017N\u001c;SK\u000e|g/\u001a:z!>Lg\u000e^(gMN,Go\u001d\u0005\b\u0003'\u0004A\u0011AAk\u0003\u00199W\r\u001e'pOR!\u0011q[Ao!\u00159\u0012\u0011\\A\u001c\u0013\r\tY\u000e\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005\u001d\u0017\u0011\u001ba\u0001\u0003WAq!!9\u0001\t\u0003\t\u0019/A\u0005de\u0016\fG/\u001a'pOR1\u0011qGAs\u0003OD\u0001\"a2\u0002`\u0002\u0007\u00111\u0006\u0005\b\u0003S\fy\u000e1\u0001;\u0003\u0019\u0019wN\u001c4jO\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=\u0018!\u00033fY\u0016$X\rT8h)\u0011\ti)!=\t\u0011\u0005\u001d\u00171\u001ea\u0001\u0003WAq!!>\u0001\t\u0013\t90\u0001\u0006oKb$Hj\\4ESJ$\u0012A\t\u0005\b\u0003w\u0004A\u0011BA\u007f\u0003Y\u0019G.Z1okB,\u0005\u0010]5sK\u0012\u001cVmZ7f]R\u001cH\u0003BA\u0006\u0003\u007fDqaAA}\u0001\u0004\t9\u0004C\u0004\u0003\u0004\u0001!IA!\u0002\u0002;\rdW-\u00198vaN+w-\\3oiN$v.T1j]R\f\u0017N\\*ju\u0016$B!a\u0003\u0003\b!91A!\u0001A\u0002\u0005]\u0002b\u0002B\u0006\u0001\u0011\u0005\u0011QV\u0001\fG2,\u0017M\\;q\u0019><7\u000fC\u0004\u0003\u0010\u0001!\tA!\u0005\u0002\u000f\u0005dG\u000eT8hgR\u0011!1\u0003\t\u0006]\tU\u0011qG\u0005\u0004\u0005/y#\u0001C%uKJ\f'\r\\3\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e\u0005!Bn\\4t\u0005f$v\u000e]5d!\u0006\u0014H/\u001b;j_:,\"Aa\b\u0011\u0011\u0005}\u0013QMA\u0016\u0003oAqAa\t\u0001\t\u0013\ti+\u0001\bgYV\u001c\b\u000eR5sifdunZ:)\u0007\u0001\u00119\u0003E\u0002\u0012\u0005SI1Aa\u000b\u0013\u0005)!\bN]3bIN\fg-\u001a")
public class LogManager
implements Logging {
    private final File[] logDirs;
    private final Map<String, LogConfig> topicConfigs;
    private final LogConfig defaultConfig;
    private final CleanerConfig cleanerConfig;
    private final long flushCheckMs;
    private final long flushCheckpointMs;
    private final long retentionCheckMs;
    public final Scheduler kafka$log$LogManager$$scheduler;
    private final Time kafka$log$LogManager$$time;
    private final String RecoveryPointCheckpointFile;
    private final String LockFile;
    private final int InitialTaskDelayMs;
    private final Object logCreationOrDeletionLock;
    private final Pool<TopicAndPartition, Log> kafka$log$LogManager$$logs;
    private final Seq<FileLock> dirLocks;
    private final scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogManager$$recoveryPointCheckpoints;
    private final LogCleaner kafka$log$LogManager$$cleaner;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogManager logManager = this;
        synchronized (logManager) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Map<String, LogConfig> topicConfigs() {
        return this.topicConfigs;
    }

    public LogConfig defaultConfig() {
        return this.defaultConfig;
    }

    public CleanerConfig cleanerConfig() {
        return this.cleanerConfig;
    }

    public long flushCheckMs() {
        return this.flushCheckMs;
    }

    public long flushCheckpointMs() {
        return this.flushCheckpointMs;
    }

    public long retentionCheckMs() {
        return this.retentionCheckMs;
    }

    public final Time kafka$log$LogManager$$time() {
        return this.kafka$log$LogManager$$time;
    }

    public String RecoveryPointCheckpointFile() {
        return this.RecoveryPointCheckpointFile;
    }

    public String LockFile() {
        return this.LockFile;
    }

    public int InitialTaskDelayMs() {
        return this.InitialTaskDelayMs;
    }

    private Object logCreationOrDeletionLock() {
        return this.logCreationOrDeletionLock;
    }

    public final Pool<TopicAndPartition, Log> kafka$log$LogManager$$logs() {
        return this.kafka$log$LogManager$$logs;
    }

    private Seq<FileLock> dirLocks() {
        return this.dirLocks;
    }

    public final scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogManager$$recoveryPointCheckpoints() {
        return this.kafka$log$LogManager$$recoveryPointCheckpoints;
    }

    public final LogCleaner kafka$log$LogManager$$cleaner() {
        return this.kafka$log$LogManager$$cleaner;
    }

    private void createAndValidateLogDirs(Seq<File> dirs) {
        if (((TraversableOnce)dirs.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(File file) {
                return file.getCanonicalPath();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().size() < dirs.size()) {
            throw new KafkaException(new StringBuilder().append((Object)"Duplicate log directory found: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).mkString(", ")).toString());
        }
        dirs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File dir$1) {
                block5: {
                    block4: {
                        if (dir$1.exists()) break block4;
                        this.$outer.info((Function0<String>)new Serializable(this, dir$1){
                            public static final long serialVersionUID;
                            private final File dir$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Log directory '").append((Object)this.dir$1.getAbsolutePath()).append((Object)"' not found, creating it.").toString();
                            }
                            {
                                this.dir$1 = file;
                            }
                        });
                        boolean created = dir$1.mkdirs();
                        if (!created) break block5;
                    }
                    if (dir$1.isDirectory() && dir$1.canRead()) {
                        return;
                    }
                    throw new KafkaException(new StringBuilder().append((Object)dir$1.getAbsolutePath()).append((Object)" is not a readable log directory.").toString());
                }
                throw new KafkaException(new StringBuilder().append((Object)"Failed to create data directory ").append((Object)dir$1.getAbsolutePath()).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private Seq<FileLock> lockLogDirs(Seq<File> dirs) {
        return (Seq)dirs.map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final FileLock apply(File dir) {
                FileLock lock2 = new FileLock(new File(dir, this.$outer.LockFile()));
                if (lock2.tryLock()) {
                    return lock2;
                }
                throw new KafkaException(new StringBuilder().append((Object)"Failed to acquire lock on file .lock in ").append((Object)lock2.file().getParentFile().getAbsolutePath()).append((Object)". A Kafka instance in another process or thread is using this directory.").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void loadLogs(Seq<File> dirs) {
        dirs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(File dir$2) {
                Object object;
                Map<TopicAndPartition, Object> recoveryPoints$1 = ((OffsetCheckpoint)this.$outer.kafka$log$LogManager$$recoveryPointCheckpoints().apply((Object)dir$2)).read();
                File[] subDirs = dir$2.listFiles();
                if (subDirs != null) {
                    File cleanShutDownFile = new File(dir$2, Log$.MODULE$.CleanShutdownFile());
                    if (cleanShutDownFile.exists()) {
                        this.$outer.info((Function0<String>)new Serializable(this, dir$2){
                            public static final long serialVersionUID;
                            private final File dir$2;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Found clean shutdown file. Skipping recovery for all logs in data directory '%s'").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir$2.getAbsolutePath()}));
                            }
                            {
                                this.dir$2 = file;
                            }
                        });
                    }
                    Predef$.MODULE$.refArrayOps((Object[])subDirs).foreach((Function1)new Serializable(this, recoveryPoints$1){
                        public static final long serialVersionUID;
                        private final $anonfun$loadLogs$1 $outer;
                        private final Map recoveryPoints$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(File dir$3) {
                            if (dir$3.isDirectory()) {
                                this.$outer.kafka$log$LogManager$$anonfun$$$outer().info((Function0<String>)new Serializable(this, dir$3){
                                    public static final long serialVersionUID;
                                    private final File dir$3;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Loading log '").append((Object)this.dir$3.getName()).append((Object)"'").toString();
                                    }
                                    {
                                        this.dir$3 = file;
                                    }
                                });
                                TopicAndPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(dir$3.getName());
                                LogConfig config = (LogConfig)this.$outer.kafka$log$LogManager$$anonfun$$$outer().topicConfigs().getOrElse((Object)topicPartition.topic(), (Function0)new Serializable(this){
                                    public static final long serialVersionUID;
                                    private final $anonfun$loadLogs$1$$anonfun$apply$4 $outer;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final LogConfig apply() {
                                        return this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().defaultConfig();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                Log log = new Log(dir$3, config, BoxesRunTime.unboxToLong((Object)this.recoveryPoints$1.getOrElse((Object)topicPartition, (Function0)new Serializable(this){
                                    public static final long serialVersionUID;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final long apply() {
                                        return this.apply$mcJ$sp();
                                    }

                                    public long apply$mcJ$sp() {
                                        return 0L;
                                    }
                                })), this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$scheduler, this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$time());
                                Log previous = this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logs().put(topicPartition, log);
                                if (previous != null) {
                                    throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Duplicate log directories found: %s, %s!").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.dir().getAbsolutePath(), previous.dir().getAbsolutePath()})));
                                }
                            }
                        }

                        public $anonfun$loadLogs$1 kafka$log$LogManager$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.recoveryPoints$1 = map;
                        }
                    });
                    object = BoxesRunTime.boxToBoolean((boolean)cleanShutDownFile.delete());
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }

            public LogManager kafka$log$LogManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void startup() {
        if (this.kafka$log$LogManager$$scheduler != null) {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Starting log cleanup with a period of %d ms.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.retentionCheckMs())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.kafka$log$LogManager$$scheduler.schedule("kafka-log-retention", (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.cleanupLogs();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, this.InitialTaskDelayMs(), this.retentionCheckMs(), TimeUnit.MILLISECONDS);
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Starting log flusher with a default period of %d ms.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.flushCheckMs())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.kafka$log$LogManager$$scheduler.schedule("kafka-log-flusher", (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$log$LogManager$$flushDirtyLogs();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, this.InitialTaskDelayMs(), this.flushCheckMs(), TimeUnit.MILLISECONDS);
            this.kafka$log$LogManager$$scheduler.schedule("kafka-recovery-point-checkpoint", (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.checkpointRecoveryPointOffsets();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, this.InitialTaskDelayMs(), this.flushCheckpointMs(), TimeUnit.MILLISECONDS);
        }
        if (this.cleanerConfig().enableCleaner()) {
            this.kafka$log$LogManager$$cleaner().startup();
        }
    }

    public void shutdown() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutting down.";
            }
        });
        try {
            if (this.kafka$log$LogManager$$cleaner() != null) {
                Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID;
                    private final LogManager $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$log$LogManager$$cleaner().shutdown();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            this.allLogs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Log log) {
                    log.flush();
                }
            });
            this.allLogs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Log log) {
                    log.close();
                }
            });
            this.checkpointRecoveryPointOffsets();
            Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(File dir$4) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, dir$4){
                        public static final long serialVersionUID;
                        private final File dir$4;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            new File(this.dir$4, Log$.MODULE$.CleanShutdownFile()).createNewFile();
                        }
                        {
                            this.dir$4 = file;
                        }
                    });
                }
            });
        }
        catch (Throwable throwable) {
            this.dirLocks().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(FileLock fileLock) {
                    fileLock.destroy();
                }
            });
            throw throwable;
        }
        this.dirLocks().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutdown complete.";
            }
        });
    }

    public void truncateTo(Map<TopicAndPartition, Object> partitionAndOffsets) {
        ((IterableLike)partitionAndOffsets.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, Object> tuple2) {
                Tuple2<TopicAndPartition, Object> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<TopicAndPartition, Object> tuple2) {
                Tuple2<TopicAndPartition, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple22._1();
                    long l = BoxesRunTime.unboxToLong((Object)tuple22._2());
                    TopicAndPartition topicAndPartition2 = topicAndPartition;
                    long truncateOffset = l;
                    Log log = this.$outer.kafka$log$LogManager$$logs().get(topicAndPartition2);
                    if (log != null) {
                        boolean needToStopCleaner;
                        boolean bl = needToStopCleaner = truncateOffset < log.activeSegment().baseOffset();
                        if (needToStopCleaner && this.$outer.kafka$log$LogManager$$cleaner() != null) {
                            this.$outer.kafka$log$LogManager$$cleaner().abortAndPauseCleaning(topicAndPartition2);
                        }
                        log.truncateTo(truncateOffset);
                        if (needToStopCleaner && this.$outer.kafka$log$LogManager$$cleaner() != null) {
                            this.$outer.kafka$log$LogManager$$cleaner().resumeCleaning(topicAndPartition2);
                        }
                    }
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.checkpointRecoveryPointOffsets();
    }

    public void truncateFullyAndStartAt(TopicAndPartition topicAndPartition, long newOffset) {
        Log log = this.kafka$log$LogManager$$logs().get(topicAndPartition);
        if (log != null) {
            if (this.kafka$log$LogManager$$cleaner() != null) {
                this.kafka$log$LogManager$$cleaner().abortAndPauseCleaning(topicAndPartition);
            }
            log.truncateFullyAndStartAt(newOffset);
            if (this.kafka$log$LogManager$$cleaner() != null) {
                this.kafka$log$LogManager$$cleaner().resumeCleaning(topicAndPartition);
            }
        }
        this.checkpointRecoveryPointOffsets();
    }

    public void checkpointRecoveryPointOffsets() {
        scala.collection.immutable.Map recoveryPointsByDir$1 = this.logsByTopicPartition().groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Tuple2<TopicAndPartition, Log> tuple2) {
                return ((Log)tuple2._2()).dir().getParent().toString();
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach((Function1)new Serializable(this, recoveryPointsByDir$1){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final scala.collection.immutable.Map recoveryPointsByDir$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File dir) {
                Option recoveryPoints = this.recoveryPointsByDir$1.get((Object)dir.toString());
                if (recoveryPoints.isDefined()) {
                    ((OffsetCheckpoint)this.$outer.kafka$log$LogManager$$recoveryPointCheckpoints().apply((Object)dir)).write((Map<TopicAndPartition, Object>)((MapLike)recoveryPoints.get()).mapValues((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final long apply(Log log) {
                            return log.recoveryPoint();
                        }
                    }));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.recoveryPointsByDir$1 = map;
            }
        });
    }

    public Option<Log> getLog(TopicAndPartition topicAndPartition) {
        Log log = this.kafka$log$LogManager$$logs().get(topicAndPartition);
        return log == null ? None$.MODULE$ : new Some((Object)log);
    }

    public Log createLog(TopicAndPartition topicAndPartition$1, LogConfig config$1) {
        Object object = this.logCreationOrDeletionLock();
        synchronized (object) {
            Log log;
            block4: {
                log = this.kafka$log$LogManager$$logs().get(topicAndPartition$1);
                if (log != null) break block4;
                File dataDir$1 = this.nextLogDir();
                File dir = new File(dataDir$1, new StringBuilder().append((Object)topicAndPartition$1.topic()).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)topicAndPartition$1.partition())).toString());
                dir.mkdirs();
                log = new Log(dir, config$1, 0L, this.kafka$log$LogManager$$scheduler, this.kafka$log$LogManager$$time());
                this.kafka$log$LogManager$$logs().put(topicAndPartition$1, log);
                this.info((Function0<String>)new Serializable(this, topicAndPartition$1, config$1, dataDir$1){
                    public static final long serialVersionUID;
                    private final TopicAndPartition topicAndPartition$1;
                    private final LogConfig config$1;
                    private final File dataDir$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Created log for partition [%s,%d] in %s with properties {%s}.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1.topic(), BoxesRunTime.boxToInteger((int)this.topicAndPartition$1.partition()), this.dataDir$1.getAbsolutePath(), JavaConversions$.MODULE$.propertiesAsScalaMap(this.config$1.toProps()).mkString(", ")}));
                    }
                    {
                        this.topicAndPartition$1 = topicAndPartition;
                        this.config$1 = logConfig;
                        this.dataDir$1 = file;
                    }
                });
                Log log2 = log;
                return log2;
            }
            return log;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteLog(TopicAndPartition topicAndPartition$2) {
        ObjectRef removedLog$1 = new ObjectRef(null);
        Object object = this.logCreationOrDeletionLock();
        synchronized (object) {
            removedLog$1.elem = this.kafka$log$LogManager$$logs().remove(topicAndPartition$2);
        }
        if ((Log)removedLog$1.elem != null) {
            if (this.kafka$log$LogManager$$cleaner() != null) {
                this.kafka$log$LogManager$$cleaner().abortCleaning(topicAndPartition$2);
            }
            ((Log)removedLog$1.elem).delete();
            this.info((Function0<String>)new Serializable(this, topicAndPartition$2, removedLog$1){
                public static final long serialVersionUID;
                private final TopicAndPartition topicAndPartition$2;
                private final ObjectRef removedLog$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Deleted log for partition [%s,%d] in %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$2.topic(), BoxesRunTime.boxToInteger((int)this.topicAndPartition$2.partition()), ((Log)this.removedLog$1.elem).dir().getAbsolutePath()}));
                }
                {
                    this.topicAndPartition$2 = topicAndPartition;
                    this.removedLog$1 = objectRef;
                }
            });
        }
    }

    private File nextLogDir() {
        File file;
        if (Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).size() == 1) {
            file = this.logDirs()[0];
        } else {
            scala.collection.immutable.Map logCounts = this.allLogs().groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(Log log) {
                    return log.dir().getParent();
                }
            }).mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(Iterable<Log> iterable) {
                    return iterable.size();
                }
            });
            scala.collection.immutable.Map zeros = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Tuple2<String, Object> apply(File dir) {
                    return new Tuple2((Object)dir.getPath(), (Object)BoxesRunTime.boxToInteger((int)0));
                }
            }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{Manifest$.MODULE$.Int()}))))).toMap(Predef$.MODULE$.conforms());
            Buffer dirCounts = zeros.$plus$plus((GenTraversableOnce)logCounts).toBuffer();
            Tuple2 leastLoaded = (Tuple2)((IterableLike)dirCounts.sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(Tuple2<String, Object> tuple2) {
                    return tuple2._2$mcI$sp();
                }
            }, (Ordering)Ordering.Int$.MODULE$)).head();
            file = new File((String)leastLoaded._1());
        }
        return file;
    }

    public final int kafka$log$LogManager$$cleanupExpiredSegments(Log log$2) {
        long startMs$1 = this.kafka$log$LogManager$$time().milliseconds();
        return log$2.deleteOldSegments((Function1<LogSegment, Object>)new Serializable(this, log$2, startMs$1){
            public static final long serialVersionUID;
            private final Log log$2;
            private final long startMs$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(LogSegment logSegment) {
                return this.startMs$1 - logSegment.lastModified() > this.log$2.config().retentionMs();
            }
            {
                this.log$2 = log;
                this.startMs$1 = l;
            }
        });
    }

    public final int kafka$log$LogManager$$cleanupSegmentsToMaintainSize(Log log) {
        if (log.config().retentionSize() < 0L || log.size() < log.config().retentionSize()) {
            return 0;
        }
        LongRef diff$1 = new LongRef(log.size() - log.config().retentionSize());
        return log.deleteOldSegments((Function1<LogSegment, Object>)new Serializable(this, diff$1){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final LongRef diff$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(LogSegment logSegment) {
                return this.$outer.shouldDelete$1(logSegment, this.diff$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.diff$1 = longRef;
            }
        });
    }

    public void cleanupLogs() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Beginning log cleanup...";
            }
        });
        IntRef total$1 = new IntRef(0);
        long startMs$2 = this.kafka$log$LogManager$$time().milliseconds();
        this.allLogs().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Log log) {
                return !log.config().compact();
            }
        }).foreach((Function1)new Serializable(this, total$1){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final IntRef total$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Log log$3) {
                this.$outer.debug((Function0<String>)new Serializable(this, log$3){
                    public static final long serialVersionUID;
                    private final Log log$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Garbage collecting '").append((Object)this.log$3.name()).append((Object)"'").toString();
                    }
                    {
                        this.log$3 = log;
                    }
                });
                this.total$1.elem += this.$outer.kafka$log$LogManager$$cleanupExpiredSegments(log$3) + this.$outer.kafka$log$LogManager$$cleanupSegmentsToMaintainSize(log$3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.total$1 = intRef;
            }
        });
        this.debug((Function0<String>)new Serializable(this, total$1, startMs$2){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final IntRef total$1;
            private final long startMs$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Log cleanup completed. ").append((Object)BoxesRunTime.boxToInteger((int)this.total$1.elem)).append((Object)" files deleted in ").append((Object)BoxesRunTime.boxToLong((long)((this.$outer.kafka$log$LogManager$$time().milliseconds() - this.startMs$2) / 1000L))).append((Object)" seconds").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.total$1 = intRef;
                this.startMs$2 = l;
            }
        });
    }

    public Iterable<Log> allLogs() {
        return this.kafka$log$LogManager$$logs().values();
    }

    public scala.collection.immutable.Map<TopicAndPartition, Log> logsByTopicPartition() {
        return this.kafka$log$LogManager$$logs().toMap(Predef$.MODULE$.conforms());
    }

    public final void kafka$log$LogManager$$flushDirtyLogs() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Checking for dirty logs to flush...";
            }
        });
        ((IterableLike)this.kafka$log$LogManager$$logs().filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, Log> tuple2) {
                Tuple2<TopicAndPartition, Log> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<TopicAndPartition, Log> tuple2) {
                Tuple2<TopicAndPartition, Log> tuple22 = tuple2;
                if (tuple22 == null) throw new MatchError(tuple22);
                TopicAndPartition topicAndPartition = (TopicAndPartition)tuple22._1();
                Log log = (Log)tuple22._2();
                TopicAndPartition topicAndPartition$3 = topicAndPartition;
                Log log$1 = log;
                try {
                    long timeSinceLastFlush$1 = this.$outer.kafka$log$LogManager$$time().milliseconds() - log$1.lastFlushTime();
                    this.$outer.debug((Function0<String>)new Serializable(this, topicAndPartition$3, log$1, timeSinceLastFlush$1){
                        public static final long serialVersionUID;
                        private final TopicAndPartition topicAndPartition$3;
                        private final Log log$1;
                        private final long timeSinceLastFlush$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Checking if flush is needed on ").append((Object)this.topicAndPartition$3.topic()).append((Object)" flush interval  ").append((Object)BoxesRunTime.boxToLong((long)this.log$1.config().flushMs())).append((Object)" last flushed ").append((Object)BoxesRunTime.boxToLong((long)this.log$1.lastFlushTime())).append((Object)" time since last flush: ").append((Object)BoxesRunTime.boxToLong((long)this.timeSinceLastFlush$1)).toString();
                        }
                        {
                            this.topicAndPartition$3 = topicAndPartition;
                            this.log$1 = log;
                            this.timeSinceLastFlush$1 = l;
                        }
                    });
                    if (timeSinceLastFlush$1 < log$1.config().flushMs()) return;
                    log$1.flush();
                    return;
                }
                catch (Throwable throwable) {
                    this.$outer.error((Function0<String>)new Serializable(this, topicAndPartition$3){
                        public static final long serialVersionUID;
                        private final TopicAndPartition topicAndPartition$3;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Error flushing topic ").append((Object)this.topicAndPartition$3.topic()).toString();
                        }
                        {
                            this.topicAndPartition$3 = topicAndPartition;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID;
                        private final Throwable e$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Throwable apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = throwable;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public final boolean shouldDelete$1(LogSegment segment, LongRef longRef) {
        boolean bl;
        if (longRef.elem - segment.size() >= 0L) {
            longRef.elem -= segment.size();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public LogManager(File[] logDirs, Map<String, LogConfig> topicConfigs, LogConfig defaultConfig, CleanerConfig cleanerConfig, long flushCheckMs, long flushCheckpointMs, long retentionCheckMs, Scheduler scheduler, Time time) {
        this.logDirs = logDirs;
        this.topicConfigs = topicConfigs;
        this.defaultConfig = defaultConfig;
        this.cleanerConfig = cleanerConfig;
        this.flushCheckMs = flushCheckMs;
        this.flushCheckpointMs = flushCheckpointMs;
        this.retentionCheckMs = retentionCheckMs;
        this.kafka$log$LogManager$$scheduler = scheduler;
        this.kafka$log$LogManager$$time = time;
        Logging$class.$init$(this);
        this.RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
        this.LockFile = ".lock";
        this.InitialTaskDelayMs = 30000;
        this.logCreationOrDeletionLock = new Object();
        this.kafka$log$LogManager$$logs = new Pool(Pool$.MODULE$.init$default$1());
        this.createAndValidateLogDirs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.dirLocks = this.lockLogDirs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.kafka$log$LogManager$$recoveryPointCheckpoints = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])logDirs).map((Function1)new $anonfun$2(this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(File.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(OffsetCheckpoint.class)}))))).toMap(Predef$.MODULE$.conforms());
        this.loadLogs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.kafka$log$LogManager$$cleaner = cleanerConfig.enableCleaner() ? new LogCleaner(cleanerConfig, logDirs, this.kafka$log$LogManager$$logs(), time) : null;
    }
}

