/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.Blacklist;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.javaapi.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.DefaultDecoder;
import kafka.serializer.DefaultDecoder$;
import kafka.tools.KafkaMigrationTool;
import kafka.tools.MirrorMaker;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class MirrorMaker$
implements Logging {
    public static final MirrorMaker$ MODULE$;
    private Seq<ZookeeperConsumerConnector> connectors;
    private Seq<MirrorMaker.MirrorMakerThread> consumerThreads;
    private ListBuffer<KafkaMigrationTool.ProducerThread> kafka$tools$MirrorMaker$$producerThreads;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new MirrorMaker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        MirrorMaker$ mirrorMaker$ = this;
        synchronized (mirrorMaker$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private Seq<ZookeeperConsumerConnector> connectors() {
        return this.connectors;
    }

    private void connectors_$eq(Seq<ZookeeperConsumerConnector> seq) {
        this.connectors = seq;
    }

    private Seq<MirrorMaker.MirrorMakerThread> consumerThreads() {
        return this.consumerThreads;
    }

    private void consumerThreads_$eq(Seq<MirrorMaker.MirrorMakerThread> seq) {
        this.consumerThreads = seq;
    }

    public final ListBuffer<KafkaMigrationTool.ProducerThread> kafka$tools$MirrorMaker$$producerThreads() {
        return this.kafka$tools$MirrorMaker$$producerThreads;
    }

    private void kafka$tools$MirrorMaker$$producerThreads_$eq(ListBuffer<KafkaMigrationTool.ProducerThread> listBuffer) {
        this.kafka$tools$MirrorMaker$$producerThreads = listBuffer;
    }

    public void main(String[] args) {
        this.info((Function0<String>)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Starting mirror maker";
            }
        });
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec consumerConfigOpt = parser.accepts("consumer.config", "Consumer config to consume from a source cluster. You may specify multiple of these.").withRequiredArg().describedAs("config file").ofType(String.class);
        ArgumentAcceptingOptionSpec producerConfigOpt$1 = parser.accepts("producer.config", "Embedded producer config.").withRequiredArg().describedAs("config file").ofType(String.class);
        ArgumentAcceptingOptionSpec numProducersOpt = parser.accepts("num.producers", "Number of producer instances").withRequiredArg().describedAs("Number of producers").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec numStreamsOpt = parser.accepts("num.streams", "Number of consumption streams.").withRequiredArg().describedAs("Number of threads").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec bufferSizeOpt = parser.accepts("queue.size", "Number of messages that are buffered between the consumer and producer").withRequiredArg().describedAs("Queue size in terms of number of messages").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec whitelistOpt = parser.accepts("whitelist", "Whitelist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        ArgumentAcceptingOptionSpec blacklistOpt = parser.accepts("blacklist", "Blacklist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print this message.");
        OptionSet options$1 = parser.parse(args);
        if (options$1.has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options$1, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{consumerConfigOpt, producerConfigOpt$1}));
        if (List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{whitelistOpt, blacklistOpt})).count((Function1)new Serializable(options$1){
            public static final long serialVersionUID;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(OptionSpec<?> optionSpec) {
                return this.options$1.has(optionSpec);
            }
            {
                this.options$1 = optionSet;
            }
        }) != 1) {
            Predef$.MODULE$.println((Object)"Exactly one of whitelist or blacklist is required.");
            System.exit(1);
        }
        Integer numStreams$1 = (Integer)options$1.valueOf((OptionSpec)numStreamsOpt);
        int bufferSize = (Integer)options$1.valueOf((OptionSpec)bufferSizeOpt);
        IndexedSeq producers$1 = (IndexedSeq)Predef$.MODULE$.intWrapper(1).to(((Integer)options$1.valueOf((OptionSpec)numProducersOpt)).intValue()).map((Function1)new Serializable(producerConfigOpt$1, options$1){
            public static final long serialVersionUID;
            private final ArgumentAcceptingOptionSpec producerConfigOpt$1;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final kafka.producer.Producer<byte[], byte[]> apply(int x$1) {
                String string;
                block4: {
                    ProducerConfig producerConfig;
                    block3: {
                        Properties props$1;
                        block2: {
                            props$1 = Utils$.MODULE$.loadProps((String)this.options$1.valueOf((OptionSpec)this.producerConfigOpt$1));
                            string = props$1.getProperty("partitioner.class");
                            if (string != null) break block2;
                            producerConfig = new ProducerConfig(this, props$1){
                                private final String partitionerClass;

                                public String partitionerClass() {
                                    return this.partitionerClass;
                                }
                                {
                                    super(properties);
                                    this.partitionerClass = "kafka.producer.ByteArrayPartitioner";
                                }
                            };
                            break block3;
                        }
                        if (string == null) break block4;
                        producerConfig = new ProducerConfig(props$1);
                    }
                    ProducerConfig config = producerConfig;
                    return new kafka.producer.Producer<byte[], byte[]>(config);
                }
                throw new MatchError((Object)string);
            }
            {
                this.producerConfigOpt$1 = argumentAcceptingOptionSpec;
                this.options$1 = optionSet;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.connectors_$eq((Seq<ZookeeperConsumerConnector>)((Seq)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(options$1.valuesOf((OptionSpec)consumerConfigOpt)).toList().map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ConsumerConfig apply(String cfg) {
                return new ConsumerConfig(Utils$.MODULE$.loadProps(cfg.toString()));
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ZookeeperConsumerConnector apply(ConsumerConfig consumerConfig) {
                return new ZookeeperConsumerConnector(consumerConfig);
            }
        }, List$.MODULE$.canBuildFrom())));
        TopicFilter filterSpec$1 = options$1.has((OptionSpec)whitelistOpt) ? new Whitelist((String)options$1.valueOf((OptionSpec)whitelistOpt)) : new Blacklist((String)options$1.valueOf((OptionSpec)blacklistOpt));
        Nil$ streams2 = Nil$.MODULE$;
        try {
            streams2 = (Seq)((GenericTraversableTemplate)this.connectors().map((Function1)new Serializable(numStreams$1, filterSpec$1){
                public static final long serialVersionUID;
                private final Integer numStreams$1;
                private final TopicFilter filterSpec$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Seq<KafkaStream<byte[], byte[]>> apply(ZookeeperConsumerConnector zookeeperConsumerConnector) {
                    return zookeeperConsumerConnector.createMessageStreamsByFilter(this.filterSpec$1, this.numStreams$1, new DefaultDecoder(DefaultDecoder$.MODULE$.init$default$1()), new DefaultDecoder(DefaultDecoder$.MODULE$.init$default$1()));
                }
                {
                    this.numStreams$1 = n;
                    this.filterSpec$1 = topicFilter;
                }
            }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms());
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Unable to create stream - shutting down mirror maker.";
                }
            });
            this.connectors().foreach((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(ZookeeperConsumerConnector zookeeperConsumerConnector) {
                    zookeeperConsumerConnector.shutdown();
                }
            });
        }
        KafkaMigrationTool.ProducerDataChannel producerDataChannel$1 = new KafkaMigrationTool.ProducerDataChannel(bufferSize);
        this.consumerThreads_$eq((Seq<MirrorMaker.MirrorMakerThread>)((Seq)((TraversableLike)streams2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(producers$1, producerDataChannel$1){
            public static final long serialVersionUID;
            private final IndexedSeq producers$1;
            private final KafkaMigrationTool.ProducerDataChannel producerDataChannel$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final MirrorMaker.MirrorMakerThread apply(Tuple2<KafkaStream<byte[], byte[]>, Object> streamAndIndex) {
                return new MirrorMaker.MirrorMakerThread((KafkaStream)streamAndIndex._1(), this.producerDataChannel$1, (Seq<kafka.producer.Producer<byte[], byte[]>>)this.producers$1, streamAndIndex._2$mcI$sp());
            }
            {
                this.producers$1 = indexedSeq;
                this.producerDataChannel$1 = producerDataChannel;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.kafka$tools$MirrorMaker$$producerThreads_$eq((ListBuffer<KafkaMigrationTool.ProducerThread>)new ListBuffer());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                MirrorMaker$.MODULE$.cleanShutdown();
            }
        });
        IntRef i$1 = new IntRef(1);
        producers$1.foreach((Function1)new Serializable(producerDataChannel$1, i$1){
            public static final long serialVersionUID;
            private final KafkaMigrationTool.ProducerDataChannel producerDataChannel$1;
            private final IntRef i$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(kafka.producer.Producer<byte[], byte[]> producer) {
                KafkaMigrationTool.ProducerThread producerThread = new KafkaMigrationTool.ProducerThread(this.producerDataChannel$1, new Producer<byte[], byte[]>(producer), this.i$1.elem);
                MirrorMaker$.MODULE$.kafka$tools$MirrorMaker$$producerThreads().$plus$eq((Object)producerThread);
                ++this.i$1.elem;
            }
            {
                this.producerDataChannel$1 = producerDataChannel;
                this.i$1 = intRef;
            }
        });
        this.consumerThreads().foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MirrorMaker.MirrorMakerThread mirrorMakerThread) {
                mirrorMakerThread.start();
            }
        });
        this.kafka$tools$MirrorMaker$$producerThreads().foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(KafkaMigrationTool.ProducerThread producerThread) {
                producerThread.start();
            }
        });
        this.consumerThreads().foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MirrorMaker.MirrorMakerThread mirrorMakerThread) {
                mirrorMakerThread.awaitShutdown();
            }
        });
        this.cleanShutdown();
    }

    public void cleanShutdown() {
        if (this.connectors() != null) {
            this.connectors().foreach((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(ZookeeperConsumerConnector zookeeperConsumerConnector) {
                    zookeeperConsumerConnector.shutdown();
                }
            });
        }
        if (this.consumerThreads() != null) {
            this.consumerThreads().foreach((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(MirrorMaker.MirrorMakerThread mirrorMakerThread) {
                    mirrorMakerThread.awaitShutdown();
                }
            });
        }
        if (this.kafka$tools$MirrorMaker$$producerThreads() != null) {
            this.kafka$tools$MirrorMaker$$producerThreads().foreach((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(KafkaMigrationTool.ProducerThread producerThread) {
                    producerThread.shutdown();
                }
            });
            this.kafka$tools$MirrorMaker$$producerThreads().foreach((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(KafkaMigrationTool.ProducerThread producerThread) {
                    producerThread.awaitShutdown();
                }
            });
        }
        this.info((Function0<String>)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Kafka mirror maker shutdown successfully";
            }
        });
    }

    private MirrorMaker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.connectors = null;
        this.consumerThreads = null;
        this.kafka$tools$MirrorMaker$$producerThreads = null;
    }
}

