/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.io.IOException;
import java.net.CookieStore;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.io.ConnectPromise;
import org.eclipse.jetty.websocket.client.io.ConnectionManager;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.client.masks.RandomMasker;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.WebSocketSessionFactory;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;

public class WebSocketClient
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(WebSocketClient.class);
    private final WebSocketPolicy policy;
    private final SslContextFactory sslContextFactory;
    private final WebSocketExtensionFactory extensionRegistry;
    private EventDriverFactory eventDriverFactory;
    private SessionFactory sessionFactory;
    private ByteBufferPool bufferPool;
    private Executor executor;
    private Scheduler scheduler;
    private CookieStore cookieStore;
    private ConnectionManager connectionManager;
    private Masker masker;
    private SocketAddress bindAddress;
    private long connectTimeout = 15000L;

    public WebSocketClient() {
        this(null, null);
    }

    public WebSocketClient(Executor executor) {
        this(null, executor);
    }

    public WebSocketClient(SslContextFactory sslContextFactory) {
        this(sslContextFactory, null);
    }

    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor) {
        this.executor = executor;
        this.sslContextFactory = sslContextFactory;
        this.policy = WebSocketPolicy.newClientPolicy();
        this.bufferPool = new MappedByteBufferPool();
        this.extensionRegistry = new WebSocketExtensionFactory(this.policy, this.bufferPool);
        this.masker = new RandomMasker();
        this.eventDriverFactory = new EventDriverFactory(this.policy);
        this.sessionFactory = new WebSocketSessionFactory();
    }

    public Future<Session> connect(Object websocket, URI toUri) throws IOException {
        ClientUpgradeRequest request = new ClientUpgradeRequest(toUri);
        request.setRequestURI(toUri);
        request.setCookiesFrom(this.cookieStore);
        return this.connect(websocket, toUri, request);
    }

    public Future<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request) throws IOException {
        return this.connect(websocket, toUri, request, null);
    }

    public Future<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request, UpgradeListener upgradeListener) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException(WebSocketClient.class.getSimpleName() + "@" + ((Object)((Object)this)).hashCode() + " is not started");
        }
        if (!toUri.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be absolute");
        }
        if (StringUtil.isBlank((String)toUri.getScheme())) {
            throw new IllegalArgumentException("WebSocket URI must include a scheme");
        }
        String scheme = toUri.getScheme().toLowerCase(Locale.ENGLISH);
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("WebSocket URI scheme only supports [ws] and [wss], not [" + scheme + "]");
        }
        request.setRequestURI(toUri);
        request.setCookiesFrom(this.cookieStore);
        for (ExtensionConfig reqExt : request.getExtensions()) {
            if (this.extensionRegistry.isAvailable(reqExt.getName())) continue;
            throw new IllegalArgumentException("Requested extension [" + reqExt.getName() + "] is not installed");
        }
        LOG.debug("connect websocket {} to {}", new Object[]{websocket, toUri});
        this.initialiseClient();
        ConnectionManager manager = this.getConnectionManager();
        EventDriver driver = null;
        driver = websocket instanceof EventDriver ? (EventDriver)websocket : this.eventDriverFactory.wrap(websocket);
        if (driver == null) {
            throw new IllegalStateException("Unable to identify as websocket object: " + websocket.getClass().getName());
        }
        ConnectPromise promise = manager.connect(this, driver, request);
        if (upgradeListener != null) {
            promise.setUpgradeListener(upgradeListener);
        }
        LOG.debug("Connect Promise: {}", new Object[]{promise});
        this.executor.execute(promise);
        return promise;
    }

    private synchronized void initialiseClient() throws IOException {
        if (this.executor == null) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            String name = WebSocketClient.class.getSimpleName() + "@" + ((Object)((Object)this)).hashCode();
            threadPool.setName(name);
            this.executor = threadPool;
            this.addBean(this.executor, true);
        } else {
            this.addBean(this.executor, false);
        }
        if (this.connectionManager != null) {
            return;
        }
        try {
            this.connectionManager = this.newConnectionManager();
            this.addBean((Object)this.connectionManager);
            this.connectionManager.start();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void doStart() throws Exception {
        LOG.debug("Starting {}", new Object[]{this});
        if (this.sslContextFactory != null) {
            this.addBean(this.sslContextFactory);
        }
        String name = WebSocketClient.class.getSimpleName() + "@" + ((Object)((Object)this)).hashCode();
        if (this.bufferPool == null) {
            this.bufferPool = new MappedByteBufferPool();
        }
        this.addBean(this.bufferPool);
        if (this.scheduler == null) {
            this.scheduler = new ScheduledExecutorScheduler(name + "-scheduler", false);
        }
        this.addBean(this.scheduler);
        if (this.cookieStore == null) {
            this.cookieStore = new HttpCookieStore.Empty();
        }
        super.doStart();
        LOG.debug("Started {}", new Object[]{this});
    }

    protected void doStop() throws Exception {
        LOG.debug("Stopping {}", new Object[]{this});
        if (this.cookieStore != null) {
            this.cookieStore.removeAll();
            this.cookieStore = null;
        }
        super.doStop();
        LOG.info("Stopped {}", new Object[]{this});
    }

    public long getAsyncWriteTimeout() {
        return this.policy.getAsyncWriteTimeout();
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public EventDriverFactory getEventDriverFactory() {
        return this.eventDriverFactory;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionRegistry;
    }

    public Masker getMasker() {
        return this.masker;
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.policy.getMaxBinaryMessageBufferSize();
    }

    public long getMaxBinaryMessageSize() {
        return this.policy.getMaxBinaryMessageSize();
    }

    public long getMaxIdleTimeout() {
        return this.policy.getIdleTimeout();
    }

    public int getMaxTextMessageBufferSize() {
        return this.policy.getMaxTextMessageBufferSize();
    }

    public long getMaxTextMessageSize() {
        return this.policy.getMaxTextMessageSize();
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    public List<Extension> initExtensions(List<ExtensionConfig> requested) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (ExtensionConfig cfg : requested) {
            Extension extension = this.extensionRegistry.newInstance(cfg);
            if (extension == null) continue;
            LOG.debug("added {}", new Object[]{extension});
            extensions.add(extension);
        }
        LOG.debug("extensions={}", new Object[]{extensions});
        return extensions;
    }

    protected ConnectionManager newConnectionManager() {
        return new ConnectionManager(this);
    }

    public void setAsyncWriteTimeout(long ms) {
        this.policy.setAsyncWriteTimeout(ms);
    }

    public void setBindAdddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public void setConnectTimeout(long ms) {
        if (ms < 0L) {
            throw new IllegalStateException("Connect Timeout cannot be negative");
        }
        this.connectTimeout = ms;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void setEventDriverFactory(EventDriverFactory factory) {
        this.eventDriverFactory = factory;
    }

    public void setExecutor(Executor executor) {
        this.updateBean(this.executor, executor);
        this.executor = executor;
    }

    public void setMasker(Masker masker) {
        this.masker = masker;
    }

    public void setMaxBinaryMessageBufferSize(int max) {
        this.policy.setMaxBinaryMessageBufferSize(max);
    }

    public void setMaxIdleTimeout(long ms) {
        this.policy.setIdleTimeout(ms);
    }

    public void setMaxTextMessageBufferSize(int max) {
        this.policy.setMaxTextMessageBufferSize(max);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

