/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.query;

import java.util.Iterator;

abstract class BaseDoubleIterator
implements Iterator<Object> {
    int index;
    private Iterator<Object> iter;
    private Iterator<Object> innerIter;
    private Object current;
    private boolean yielded;
    private boolean inOuter;
    Object outerItem = null;

    BaseDoubleIterator(Iterable<Object> base) {
        this.iter = base.iterator();
        this.inOuter = true;
    }

    @Override
    public Object next() {
        ++this.index;
        this.yielded = false;
        return this.current;
    }

    @Override
    public boolean hasNext() {
        while (!this.yielded) {
            if (this.inOuter) {
                if (!this.iter.hasNext()) break;
                this.outerItem = this.iter.next();
                this.innerIter = this.doItem(this.outerItem);
                if (this.innerIter == null) continue;
                this.inOuter = false;
                continue;
            }
            if (this.innerIter.hasNext()) {
                this.doItem(this.outerItem, this.innerIter.next());
                continue;
            }
            this.inOuter = true;
        }
        return this.yielded;
    }

    abstract Iterator<Object> doItem(Object var1);

    abstract void doItem(Object var1, Object var2);

    void yield(Object current) {
        this.current = current;
        this.yielded = true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

