/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.query;

import java.util.Collections;
import java.util.Iterator;

public class Generation {
    public static Iterable<Integer> range(final int start, final int count) {
        if (count < 0 || (long)start + (long)count - 1L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("count for range operator is out of range.");
        }
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    int index = 0;
                    int current;
                    {
                        this.current = start;
                    }

                    @Override
                    public Integer next() {
                        ++this.index;
                        return new Integer(this.current++);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < count;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<Object> repeat(final Object obj, final int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count for repeat operator is out of range.");
        }
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    int index = 0;
                    Object current;
                    {
                        this.current = obj;
                    }

                    @Override
                    public Object next() {
                        ++this.index;
                        return this.current;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < count;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable empty() {
        return Collections.EMPTY_LIST;
    }
}

