/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.LambdaExpression;

class OrderIterable
implements Iterable<Object> {
    private final List<OrderParam> orderParams = new ArrayList<OrderParam>();
    ELContext context;
    private List<Object> base;
    private boolean sorted = false;

    public OrderIterable(ELContext context, List<Object> base, LambdaExpression keySelector, Comparator<Object> cmp, boolean descending) {
        this.context = context;
        this.base = base;
        this.orderParams.add(new OrderParam(keySelector, cmp, descending));
    }

    private void sort() {
        if (this.sorted) {
            return;
        }
        Collections.sort(this.base, new ItemComparator());
        this.sorted = true;
    }

    void addOrder(LambdaExpression keySelector, Comparator<Object> cmp, boolean descending) {
        this.orderParams.add(new OrderParam(keySelector, cmp, descending));
    }

    @Override
    public Iterator<Object> iterator() {
        this.sort();
        return this.base.iterator();
    }

    private class OrderParam {
        private LambdaExpression selector;
        private Comparator<Object> comparator;
        private boolean descending;

        OrderParam(LambdaExpression selector, Comparator<Object> comparator, boolean descending) {
            this.selector = selector;
            this.comparator = comparator;
            this.descending = descending;
        }

        LambdaExpression getSelector() {
            return this.selector;
        }

        Comparator<Object> getComparator() {
            return this.comparator;
        }

        boolean isDescending() {
            return this.descending;
        }
    }

    private class ItemComparator
    implements Comparator<Object> {
        private ItemComparator() {
        }

        @Override
        public int compare(Object item, Object item2) {
            for (OrderParam orderParam : OrderIterable.this.orderParams) {
                Object key1 = orderParam.getSelector().invoke(OrderIterable.this.context, item);
                Object key2 = orderParam.getSelector().invoke(OrderIterable.this.context, item2);
                Comparator<Object> comparator = orderParam.getComparator();
                int result = 0;
                if (comparator != null) {
                    result = comparator.compare(key1, key2);
                } else if (key1 instanceof Comparable) {
                    int temp;
                    result = temp = ((Comparable)key1).compareTo(key2);
                }
                if (result == 0) continue;
                if (orderParam.isDescending()) {
                    return -result;
                }
                return result;
            }
            return 0;
        }
    }
}

