/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.query;

import com.sun.el.query.Aggregate;
import com.sun.el.query.All;
import com.sun.el.query.Any;
import com.sun.el.query.Average;
import com.sun.el.query.Concat;
import com.sun.el.query.Contains;
import com.sun.el.query.Count;
import com.sun.el.query.DefaultEmpty;
import com.sun.el.query.Distinct;
import com.sun.el.query.ElementAt;
import com.sun.el.query.ElementAtOrDefault;
import com.sun.el.query.Except;
import com.sun.el.query.First;
import com.sun.el.query.FirstOrDefault;
import com.sun.el.query.ForEach;
import com.sun.el.query.GroupBy;
import com.sun.el.query.GroupJoin;
import com.sun.el.query.Intersect;
import com.sun.el.query.Join;
import com.sun.el.query.Last;
import com.sun.el.query.LastOrDefault;
import com.sun.el.query.Max;
import com.sun.el.query.Min;
import com.sun.el.query.OrderBy;
import com.sun.el.query.OrderByDescending;
import com.sun.el.query.Reverse;
import com.sun.el.query.Select;
import com.sun.el.query.SelectMany;
import com.sun.el.query.SequenceEqual;
import com.sun.el.query.Single;
import com.sun.el.query.SingleOrDefault;
import com.sun.el.query.Skip;
import com.sun.el.query.SkipWhile;
import com.sun.el.query.Sum;
import com.sun.el.query.Take;
import com.sun.el.query.TakeWhile;
import com.sun.el.query.ThenBy;
import com.sun.el.query.ThenByDescending;
import com.sun.el.query.ToArray;
import com.sun.el.query.ToList;
import com.sun.el.query.ToLookup;
import com.sun.el.query.ToMap;
import com.sun.el.query.Union;
import com.sun.el.query.Where;
import java.util.Comparator;
import java.util.HashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.LambdaExpression;

public abstract class QueryOperator {
    static final HashMap<String, QueryOperator> operators = new HashMap();

    public abstract Object invoke(ELContext var1, Iterable<Object> var2, Object[] var3);

    public static QueryOperator getQueryOperator(String operator) {
        return operators.get(operator);
    }

    static LambdaExpression getLambda(String name, Object[] params, int i) {
        return QueryOperator.getLambda(name, params, i, false);
    }

    static LambdaExpression getLambda(String name, Object[] params, int i, boolean optional) {
        if (i >= params.length || !(params[i] instanceof LambdaExpression)) {
            if (optional) {
                return null;
            }
            throw new ELException("Expecting a Lambda Expression for argument " + i + " of " + name + " operator.");
        }
        return (LambdaExpression)params[i];
    }

    static Object getArgument(String name, Object[] params, int i) {
        return QueryOperator.getArgument(name, params, i, false);
    }

    static Object getArgument(String name, Object[] params, int i, boolean optional) {
        if (i >= params.length) {
            if (optional) {
                return null;
            }
            throw new ELException("Expecting argument " + i + " of " + name + " operator.");
        }
        return params[i];
    }

    static int getInt(String name, Object[] params, int i) {
        String msg = "Expecting an integer for argument " + i + " of " + name + " operator.";
        if (i >= params.length) {
            throw new ELException(msg);
        }
        return QueryOperator.toInteger(params[i], msg);
    }

    static Iterable<Object> getIterable(String name, Object[] params, int i) {
        if (i >= params.length || !(params[i] instanceof Iterable)) {
            throw new ELException("Expecting an Iterable for argument " + i + " of " + name + " operator.");
        }
        Iterable result = (Iterable)params[i];
        return result;
    }

    static Comparator<Object> getComparator(String name, Object[] params, int i, boolean optional) {
        if (i >= params.length || !(params[i] instanceof Comparator)) {
            if (optional) {
                return null;
            }
            throw new ELException("Expecting a Comparartor for argument " + i + " of " + name + " operator.");
        }
        Comparator result = (Comparator)params[i];
        return result;
    }

    private static int toInteger(Object p, String msg) {
        if (p instanceof Integer) {
            return (Integer)p;
        }
        if (p instanceof Character) {
            return ((Character)p).charValue();
        }
        if (p instanceof Number) {
            return ((Number)p).intValue();
        }
        if (p instanceof String) {
            return Integer.parseInt((String)p);
        }
        throw new IllegalArgumentException(msg);
    }

    static {
        operators.put("where", new Where());
        operators.put("select", new Select());
        operators.put("selectMany", new SelectMany());
        operators.put("take", new Take());
        operators.put("skip", new Skip());
        operators.put("takeWhile", new TakeWhile());
        operators.put("skipWhile", new SkipWhile());
        operators.put("join", new Join());
        operators.put("groupJoin", new GroupJoin());
        operators.put("concat", new Concat());
        operators.put("orderBy", new OrderBy());
        operators.put("thenBy", new ThenBy());
        operators.put("orderByDescending", new OrderByDescending());
        operators.put("thenByDescending", new ThenByDescending());
        operators.put("reverse", new Reverse());
        operators.put("groupBy", new GroupBy());
        operators.put("distinct", new Distinct());
        operators.put("union", new Union());
        operators.put("intersect", new Intersect());
        operators.put("except", new Except());
        operators.put("toArray", new ToArray());
        operators.put("toList", new ToList());
        operators.put("toMap", new ToMap());
        operators.put("toLookup", new ToLookup());
        operators.put("sequenceEqual", new SequenceEqual());
        operators.put("first", new First());
        operators.put("firstOrDefault", new FirstOrDefault());
        operators.put("last", new Last());
        operators.put("lastOrDefault", new LastOrDefault());
        operators.put("single", new Single());
        operators.put("singleOrDefault", new SingleOrDefault());
        operators.put("elementAt", new ElementAt());
        operators.put("elementAtOrDefault", new ElementAtOrDefault());
        operators.put("defaultEmpty", new DefaultEmpty());
        operators.put("any", new Any());
        operators.put("all", new All());
        operators.put("contains", new Contains());
        operators.put("count", new Count());
        operators.put("sum", new Sum());
        operators.put("min", new Min());
        operators.put("max", new Max());
        operators.put("average", new Average());
        operators.put("aggregate", new Aggregate());
        operators.put("forEach", new ForEach());
    }
}

