/*
 * Decompiled with CFR 0.152.
 */
package org.log4mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bson.BSONObject;
import org.log4mongo.MongoDbAppender;

public class ExtendedMongoDbAppender
extends MongoDbAppender {
    private DBObject constants;
    private Map<String, String> rootProperties = new LinkedHashMap<String, String>();

    public void activateOptions() {
        super.activateOptions();
        this.initTopLevelProperties();
    }

    public void initTopLevelProperties() {
        this.constants = new BasicDBObject();
        if (!this.rootProperties.isEmpty()) {
            this.constants.putAll(this.rootProperties);
        }
    }

    public void setRootLevelProperties(String rootLevelProperties) {
        for (String keyValue : rootLevelProperties.split(" *& *")) {
            String[] pairs = keyValue.split(" *= *", 2);
            this.rootProperties.put(pairs[0], pairs.length == 1 ? "" : pairs[1]);
        }
    }

    public void append(DBObject bson) {
        if (this.isInitialized() && bson != null) {
            if (this.constants != null) {
                bson.putAll((BSONObject)this.constants);
            }
            super.append(bson);
        }
    }
}

