/*
 * Decompiled with CFR 0.152.
 */
package org.log4mongo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.log4mongo.LoggingEventBsonifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEventBsonifierImpl
implements LoggingEventBsonifier {
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_LEVEL = "level";
    private static final String KEY_THREAD = "thread";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_LOGGER_NAME = "loggerName";
    private static final String KEY_FILE_NAME = "fileName";
    private static final String KEY_METHOD = "method";
    private static final String KEY_LINE_NUMBER = "lineNumber";
    private static final String KEY_CLASS = "class";
    private static final String KEY_FQCN = "fullyQualifiedClassName";
    private static final String KEY_PACKAGE = "package";
    private static final String KEY_CLASS_NAME = "className";
    private static final String KEY_THROWABLES = "throwables";
    private static final String KEY_EXCEPTION_MESSAGE = "message";
    private static final String KEY_STACK_TRACE = "stackTrace";
    private static final String KEY_HOST = "host";
    private static final String KEY_PROCESS = "process";
    private static final String KEY_HOSTNAME = "name";
    private static final String KEY_IP = "ip";
    private static final String KEY_MDC_PROPERTIES = "properties";
    private DBObject hostInfo = new BasicDBObject();

    public LoggingEventBsonifierImpl() {
        this.setupNetworkInfo();
    }

    private void setupNetworkInfo() {
        this.hostInfo.put(KEY_PROCESS, (Object)ManagementFactory.getRuntimeMXBean().getName());
        try {
            this.hostInfo.put(KEY_HOSTNAME, (Object)InetAddress.getLocalHost().getHostName());
            this.hostInfo.put(KEY_IP, (Object)InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            LogLog.warn((String)e.getMessage());
        }
    }

    @Override
    public DBObject bsonify(LoggingEvent loggingEvent) {
        BasicDBObject result = null;
        if (loggingEvent != null) {
            result = new BasicDBObject();
            result.put(KEY_TIMESTAMP, (Object)new Date(loggingEvent.getTimeStamp()));
            this.nullSafePut((DBObject)result, KEY_LEVEL, loggingEvent.getLevel().toString());
            this.nullSafePut((DBObject)result, KEY_THREAD, loggingEvent.getThreadName());
            this.nullSafePut((DBObject)result, "message", loggingEvent.getMessage());
            this.nullSafePut((DBObject)result, KEY_LOGGER_NAME, this.bsonifyClassName(loggingEvent.getLoggerName()));
            this.addMDCInformation((DBObject)result, loggingEvent.getProperties());
            this.addLocationInformation((DBObject)result, loggingEvent.getLocationInformation());
            this.addThrowableInformation((DBObject)result, loggingEvent.getThrowableInformation());
            this.addHostnameInformation((DBObject)result);
        }
        return result;
    }

    protected void addMDCInformation(DBObject bson, Map<Object, Object> props) {
        if (props != null && props.size() > 0) {
            BasicDBObject mdcProperties = new BasicDBObject();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                this.nullSafePut((DBObject)mdcProperties, entry.getKey().toString(), entry.getValue().toString());
            }
            bson.put(KEY_MDC_PROPERTIES, (Object)mdcProperties);
        }
    }

    protected void addLocationInformation(DBObject bson, LocationInfo locationInfo) {
        if (locationInfo != null) {
            this.nullSafePut(bson, KEY_FILE_NAME, locationInfo.getFileName());
            this.nullSafePut(bson, KEY_METHOD, locationInfo.getMethodName());
            this.nullSafePut(bson, KEY_LINE_NUMBER, locationInfo.getLineNumber());
            this.nullSafePut(bson, KEY_CLASS, this.bsonifyClassName(locationInfo.getClassName()));
        }
    }

    protected void addThrowableInformation(DBObject bson, ThrowableInformation throwableInfo) {
        if (throwableInfo != null) {
            BasicDBList throwables = new BasicDBList();
            for (Throwable currentThrowable = throwableInfo.getThrowable(); currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
                DBObject throwableBson = this.bsonifyThrowable(currentThrowable);
                if (throwableBson == null) continue;
                throwables.add(throwableBson);
            }
            if (throwables.size() > 0) {
                bson.put(KEY_THROWABLES, (Object)throwables);
            }
        }
    }

    protected void addHostnameInformation(DBObject bson) {
        this.nullSafePut(bson, KEY_HOST, this.hostInfo);
    }

    protected DBObject bsonifyThrowable(Throwable throwable) {
        BasicDBObject result = null;
        if (throwable != null) {
            result = new BasicDBObject();
            this.nullSafePut((DBObject)result, "message", throwable.getMessage());
            this.nullSafePut((DBObject)result, KEY_STACK_TRACE, this.bsonifyStackTrace(throwable.getStackTrace()));
        }
        return result;
    }

    protected DBObject bsonifyStackTrace(StackTraceElement[] stackTrace) {
        BasicDBList result = null;
        if (stackTrace != null && stackTrace.length > 0) {
            result = new BasicDBList();
            for (StackTraceElement element : stackTrace) {
                DBObject bson = this.bsonifyStackTraceElement(element);
                if (bson == null) continue;
                result.add((Object)bson);
            }
        }
        return result;
    }

    protected DBObject bsonifyStackTraceElement(StackTraceElement element) {
        BasicDBObject result = null;
        if (element != null) {
            result = new BasicDBObject();
            this.nullSafePut((DBObject)result, KEY_FILE_NAME, element.getFileName());
            this.nullSafePut((DBObject)result, KEY_METHOD, element.getMethodName());
            this.nullSafePut((DBObject)result, KEY_LINE_NUMBER, element.getLineNumber());
            this.nullSafePut((DBObject)result, KEY_CLASS, this.bsonifyClassName(element.getClassName()));
        }
        return result;
    }

    protected DBObject bsonifyClassName(String className) {
        BasicDBObject result = null;
        if (className != null && className.trim().length() > 0) {
            result = new BasicDBObject();
            result.put(KEY_FQCN, (Object)className);
            BasicDBList packageComponents = new BasicDBList();
            String[] packageAndClassName = className.split("\\.");
            packageComponents.addAll(Arrays.asList(packageAndClassName));
            if (packageComponents.size() > 0) {
                result.put(KEY_PACKAGE, (Object)packageComponents);
            }
            result.put(KEY_CLASS_NAME, (Object)packageAndClassName[packageAndClassName.length - 1]);
        }
        return result;
    }

    protected void nullSafePut(DBObject bson, String key, Object value) {
        if (value != null) {
            if (value instanceof String) {
                String stringValue = (String)value;
                if (stringValue.trim().length() > 0) {
                    bson.put(key, (Object)stringValue);
                }
            } else if (value instanceof StringBuffer) {
                String stringValue = ((StringBuffer)value).toString();
                if (stringValue.trim().length() > 0) {
                    bson.put(key, (Object)stringValue);
                }
            } else {
                bson.put(key, value);
            }
        }
    }
}

