/*
 * Decompiled with CFR 0.152.
 */
package org.log4mongo;

import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class MongoDbPatternLayout
extends PatternLayout {
    private StringBuffer buf = new StringBuffer(256);
    private StringBuilder builder = new StringBuilder(256);
    private String conversionPattern;
    private PatternConverter headConverter;

    public MongoDbPatternLayout() {
        this("%m%n");
    }

    public MongoDbPatternLayout(String pattern) {
        this.conversionPattern = pattern;
        this.headConverter = this.createPatternParser(pattern == null ? "%m%n" : pattern).parse();
    }

    public void setConversionPattern(String conversionPattern) {
        this.conversionPattern = conversionPattern;
        this.headConverter = this.createPatternParser(conversionPattern).parse();
    }

    public String getConversionPattern() {
        return this.conversionPattern;
    }

    public PatternParser createPatternParser(String pattern) {
        PatternParser parser = pattern == null ? new PatternParser("%m%n") : new PatternParser(pattern);
        return parser;
    }

    public String format(LoggingEvent event) {
        if (this.builder.capacity() > 1024) {
            this.builder = new StringBuilder(256);
        } else {
            this.builder.setLength(0);
        }
        PatternConverter c = this.headConverter;
        while (c != null) {
            if (this.buf.capacity() > 1024) {
                this.buf = new StringBuffer(256);
            } else {
                this.buf.setLength(0);
            }
            c.format(this.buf, event);
            if (c.getClass().getSimpleName().equals("LiteralPatternConverter")) {
                this.builder.append(this.buf);
            } else {
                char[] chars = this.buf.toString().toCharArray();
                int pos = 0;
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] == '\"') {
                        this.builder.append(chars, pos, i - pos).append("\\\"");
                        pos = i + 1;
                        continue;
                    }
                    if (chars[i] != '\\') continue;
                    this.builder.append(chars, pos, i - pos).append("\\\\");
                    pos = i + 1;
                }
                this.builder.append(chars, pos, chars.length - pos);
            }
            c = c.next;
        }
        return this.builder.toString();
    }
}

