/*
 * Decompiled with CFR 0.152.
 */
package org.log4mongo.contrib;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class HostInfoPatternParser
extends PatternParser {
    static final char HOST_NAME = 'H';
    static final char VM_NAME = 'V';
    static final char IP_ADDRESS = 'I';
    static final Map<String, PatternConverter> converters;

    public HostInfoPatternParser(String pattern) {
        super(pattern);
    }

    public void finalizeConverter(char formatChar) {
        PatternConverter pc = null;
        switch (formatChar) {
            case 'H': {
                pc = converters.get(String.valueOf('H'));
                this.currentLiteral.setLength(0);
                this.addConverter(pc);
                break;
            }
            case 'V': {
                pc = converters.get(String.valueOf('V'));
                this.currentLiteral.setLength(0);
                this.addConverter(pc);
                break;
            }
            case 'I': {
                pc = converters.get(String.valueOf('I'));
                this.currentLiteral.setLength(0);
                this.addConverter(pc);
                break;
            }
            default: {
                super.finalizeConverter(formatChar);
            }
        }
    }

    static {
        HashMap<String, PatternConverter> tmp = new HashMap<String, PatternConverter>();
        tmp.put(String.valueOf('H'), new HostPatternConverter());
        tmp.put(String.valueOf('V'), new VMNamePatternConverter());
        tmp.put(String.valueOf('I'), new IPAddressPatternConverter());
        converters = Collections.unmodifiableMap(tmp);
    }

    private static class IPAddressPatternConverter
    extends PatternConverter {
        private String ipaddress = "";

        IPAddressPatternConverter() {
            try {
                this.ipaddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                LogLog.warn((String)e.getMessage());
            }
        }

        public String convert(LoggingEvent event) {
            return this.ipaddress;
        }
    }

    private static class VMNamePatternConverter
    extends PatternConverter {
        private String process = ManagementFactory.getRuntimeMXBean().getName();

        VMNamePatternConverter() {
        }

        public String convert(LoggingEvent event) {
            return this.process;
        }
    }

    private static class HostPatternConverter
    extends PatternConverter {
        private String hostname = "";

        HostPatternConverter() {
            try {
                this.hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LogLog.warn((String)e.getMessage());
            }
        }

        public String convert(LoggingEvent event) {
            return this.hostname;
        }
    }
}

