/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonRootValue;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithPath;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithoutPath;
import au.com.dius.pact.consumer.dsl.PactDslWithState;
import au.com.dius.pact.consumer.dsl.QuoteUtil;
import au.com.dius.pact.consumer.xml.PactXmlBuilder;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.RequestResponseInteraction;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.model.Response;
import au.com.dius.pact.core.model.generators.Category;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.Generators;
import au.com.dius.pact.core.model.generators.ProviderStateGenerator;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRules;
import au.com.dius.pact.core.model.matchingrules.MatchingRulesImpl;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import au.com.dius.pact.core.model.matchingrules.RuleLogic;
import au.com.dius.pact.core.support.expressions.DataType;
import com.google.common.collect.Lists;
import com.mifmif.common.regex.Generex;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;
import org.w3c.dom.Document;

public class PactDslResponse {
    private static final String CONTENT_TYPE = "Content-Type";
    static final String DEFAULT_JSON_CONTENT_TYPE_REGEX = "application/json(;\\s?charset=[\\w\\-]+)?";
    private final ConsumerPactBuilder consumerPactBuilder;
    private PactDslRequestWithPath request;
    private final PactDslRequestWithoutPath defaultRequestValues;
    private final PactDslResponse defaultResponseValues;
    private int responseStatus = 200;
    private Map<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
    private OptionalBody responseBody = OptionalBody.missing();
    private MatchingRules responseMatchers = new MatchingRulesImpl();
    private Generators responseGenerators = new Generators();

    public PactDslResponse(ConsumerPactBuilder consumerPactBuilder, PactDslRequestWithPath request, PactDslRequestWithoutPath defaultRequestValues, PactDslResponse defaultResponseValues) {
        this.consumerPactBuilder = consumerPactBuilder;
        this.request = request;
        this.defaultRequestValues = defaultRequestValues;
        this.defaultResponseValues = defaultResponseValues;
        this.setupDefaultValues();
    }

    private void setupDefaultValues() {
        if (this.defaultResponseValues != null) {
            this.responseStatus = this.defaultResponseValues.responseStatus;
            this.responseHeaders.putAll(this.defaultResponseValues.responseHeaders);
            this.responseBody = this.defaultResponseValues.responseBody;
            this.responseMatchers = ((MatchingRulesImpl)this.defaultResponseValues.responseMatchers).copy();
            this.responseGenerators = new Generators(this.defaultResponseValues.responseGenerators.getCategories());
        }
    }

    public PactDslResponse status(int status) {
        this.responseStatus = status;
        return this;
    }

    public PactDslResponse headers(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.responseHeaders.put(entry.getKey(), Collections.singletonList(entry.getValue()));
        }
        return this;
    }

    public PactDslResponse body(String body) {
        this.responseBody = OptionalBody.body((byte[])body.getBytes());
        return this;
    }

    public PactDslResponse body(String body, String contentType) {
        return this.body(body, ContentType.parse((String)contentType));
    }

    public PactDslResponse body(String body, ContentType contentType) {
        Charset charset = contentType.getCharset() == null ? Charset.defaultCharset() : contentType.getCharset();
        this.responseBody = OptionalBody.body((byte[])body.getBytes(charset), (au.com.dius.pact.core.model.ContentType)new au.com.dius.pact.core.model.ContentType(contentType.toString()));
        this.responseHeaders.put(CONTENT_TYPE, Collections.singletonList(contentType.toString()));
        return this;
    }

    public PactDslResponse body(Supplier<String> body) {
        this.responseBody = OptionalBody.body((byte[])body.get().getBytes());
        return this;
    }

    public PactDslResponse body(Supplier<String> body, String contentType) {
        return this.body(body, contentType);
    }

    public PactDslResponse body(Supplier<String> body, ContentType contentType) {
        Charset charset = contentType.getCharset() == null ? Charset.defaultCharset() : contentType.getCharset();
        this.responseBody = OptionalBody.body((byte[])body.get().getBytes(charset), (au.com.dius.pact.core.model.ContentType)new au.com.dius.pact.core.model.ContentType(contentType.toString()));
        this.responseHeaders.put(CONTENT_TYPE, Collections.singletonList(contentType.toString()));
        return this;
    }

    public PactDslResponse bodyWithSingleQuotes(String body) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body);
    }

    public PactDslResponse bodyWithSingleQuotes(String body, String contentType) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body, contentType);
    }

    public PactDslResponse bodyWithSingleQuotes(String body, ContentType contentType) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body, contentType);
    }

    public PactDslResponse body(JSONObject body) {
        if (this.isContentTypeHeaderNotSet()) {
            this.matchHeader(CONTENT_TYPE, DEFAULT_JSON_CONTENT_TYPE_REGEX, ContentType.APPLICATION_JSON.toString());
            this.responseBody = OptionalBody.body((byte[])body.toString().getBytes());
        } else {
            String contentType = this.getContentTypeHeader();
            ContentType ct = ContentType.parse((String)contentType);
            Charset charset = ct.getCharset() != null ? ct.getCharset() : Charset.defaultCharset();
            this.responseBody = OptionalBody.body((byte[])body.toString().getBytes(charset), (au.com.dius.pact.core.model.ContentType)new au.com.dius.pact.core.model.ContentType(contentType));
        }
        return this;
    }

    public PactDslResponse body(DslPart body) {
        DslPart parent = body.close();
        if (parent instanceof PactDslJsonRootValue) {
            ((PactDslJsonRootValue)parent).setEncodeJson(true);
        }
        this.responseMatchers.addCategory(parent.getMatchers());
        this.responseGenerators.addGenerators(parent.generators);
        Charset charset = Charset.defaultCharset();
        String contentType = ContentType.APPLICATION_JSON.toString();
        if (this.isContentTypeHeaderNotSet()) {
            this.matchHeader(CONTENT_TYPE, DEFAULT_JSON_CONTENT_TYPE_REGEX, contentType);
        } else {
            contentType = this.getContentTypeHeader();
            ContentType ct = ContentType.parse((String)contentType);
            charset = ct.getCharset() != null ? ct.getCharset() : Charset.defaultCharset();
        }
        this.responseBody = parent.getBody() != null ? OptionalBody.body((byte[])parent.getBody().toString().getBytes(charset), (au.com.dius.pact.core.model.ContentType)new au.com.dius.pact.core.model.ContentType(contentType)) : OptionalBody.nullBody();
        return this;
    }

    public PactDslResponse body(Document body) throws TransformerException {
        if (this.isContentTypeHeaderNotSet()) {
            this.responseHeaders.put(CONTENT_TYPE, Collections.singletonList(ContentType.APPLICATION_XML.toString()));
            this.responseBody = OptionalBody.body((byte[])ConsumerPactBuilder.xmlToString(body).getBytes());
        } else {
            String contentType = this.getContentTypeHeader();
            ContentType ct = ContentType.parse((String)contentType);
            Charset charset = ct.getCharset() != null ? ct.getCharset() : Charset.defaultCharset();
            this.responseBody = OptionalBody.body((byte[])ConsumerPactBuilder.xmlToString(body).getBytes(charset), (au.com.dius.pact.core.model.ContentType)new au.com.dius.pact.core.model.ContentType(contentType));
        }
        return this;
    }

    public PactDslResponse matchHeader(String header, String regexp) {
        return this.matchHeader(header, regexp, new Generex(regexp).random());
    }

    public PactDslResponse matchHeader(String header, String regexp, String headerExample) {
        this.responseMatchers.addCategory("header").setRule(header, (MatchingRule)new RegexMatcher(regexp));
        this.responseHeaders.put(header, Collections.singletonList(headerExample));
        return this;
    }

    private void addInteraction() {
        this.consumerPactBuilder.getInteractions().add(new RequestResponseInteraction(this.request.description, this.request.state, new Request(this.request.requestMethod, this.request.path, this.request.query, this.request.requestHeaders, this.request.requestBody, this.request.requestMatchers, this.request.requestGenerators), new Response(this.responseStatus, this.responseHeaders, this.responseBody, this.responseMatchers, this.responseGenerators), null));
    }

    public RequestResponsePact toPact() {
        this.addInteraction();
        return new RequestResponsePact(this.request.provider, this.request.consumer, this.consumerPactBuilder.getInteractions());
    }

    public PactDslRequestWithPath uponReceiving(String description) {
        this.addInteraction();
        return new PactDslRequestWithPath(this.consumerPactBuilder, this.request, description, this.defaultRequestValues, this.defaultResponseValues);
    }

    public PactDslWithState given(String state) {
        this.addInteraction();
        return new PactDslWithState(this.consumerPactBuilder, this.request.consumer.getName(), this.request.provider.getName(), new ProviderState(state), this.defaultRequestValues, this.defaultResponseValues);
    }

    public PactDslWithState given(String state, Map<String, Object> params) {
        this.addInteraction();
        return new PactDslWithState(this.consumerPactBuilder, this.request.consumer.getName(), this.request.provider.getName(), new ProviderState(state, params), this.defaultRequestValues, this.defaultResponseValues);
    }

    public PactDslResponse headerFromProviderState(String name, String expression, String example) {
        this.responseGenerators.addGenerator(Category.HEADER, name, (Generator)new ProviderStateGenerator(expression, DataType.STRING));
        this.responseHeaders.put(name, Collections.singletonList(example));
        return this;
    }

    public PactDslResponse matchSetCookie(String cookie, String regex, String example) {
        au.com.dius.pact.core.model.matchingrules.Category header = this.responseMatchers.addCategory("header");
        if (header.numRules("set-cookie") > 0) {
            header.addRule("set-cookie", (MatchingRule)new RegexMatcher(Pattern.quote(cookie + "=") + regex));
        } else {
            header.setRule("set-cookie", (MatchingRule)new RegexMatcher(Pattern.quote(cookie + "=") + regex), RuleLogic.OR);
        }
        if (this.responseHeaders.containsKey("set-cookie")) {
            this.responseHeaders.get("set-cookie").add(cookie + "=" + example);
        } else {
            this.responseHeaders.put("set-cookie", Lists.newArrayList((Object[])new String[]{cookie + "=" + example}));
        }
        return this;
    }

    public PactDslResponse body(PactXmlBuilder xmlBuilder) {
        this.responseMatchers.addCategory(xmlBuilder.getMatchingRules());
        this.responseGenerators.addGenerators(xmlBuilder.getGenerators());
        if (this.isContentTypeHeaderNotSet()) {
            this.responseHeaders.put(CONTENT_TYPE, Collections.singletonList(ContentType.APPLICATION_XML.toString()));
            this.responseBody = OptionalBody.body((byte[])xmlBuilder.asBytes());
        } else {
            String contentType = this.getContentTypeHeader();
            ContentType ct = ContentType.parse((String)contentType);
            Charset charset = ct.getCharset() != null ? ct.getCharset() : Charset.defaultCharset();
            this.responseBody = OptionalBody.body((byte[])xmlBuilder.asBytes(charset), (au.com.dius.pact.core.model.ContentType)new au.com.dius.pact.core.model.ContentType(contentType));
        }
        return this;
    }

    protected boolean isContentTypeHeaderNotSet() {
        return this.responseHeaders.keySet().stream().noneMatch(key -> key.equalsIgnoreCase(CONTENT_TYPE));
    }

    protected String getContentTypeHeader() {
        return this.responseHeaders.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(CONTENT_TYPE)).findFirst().map(entry -> (String)((List)entry.getValue()).get(0)).orElse("");
    }
}

