/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.util.SaTokenInsideUtil;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class SaTokenDaoRedisJackson
implements SaTokenDao {
    public ObjectMapper objectMapper;
    @Autowired
    public StringRedisTemplate stringRedisTemplate;
    public RedisTemplate<String, Object> objectRedisTemplate;

    @Autowired
    public void setObjectRedisTemplate(RedisConnectionFactory connectionFactory) {
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        GenericJackson2JsonRedisSerializer valueSerializer = new GenericJackson2JsonRedisSerializer();
        try {
            Field field = GenericJackson2JsonRedisSerializer.class.getDeclaredField("mapper");
            field.setAccessible(true);
            ObjectMapper objectMapper = (ObjectMapper)field.get(valueSerializer);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.objectMapper = objectMapper;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(connectionFactory);
        template.setKeySerializer((RedisSerializer)keySerializer);
        template.setHashKeySerializer((RedisSerializer)keySerializer);
        template.setValueSerializer((RedisSerializer)valueSerializer);
        template.setHashValueSerializer((RedisSerializer)valueSerializer);
        template.afterPropertiesSet();
        if (this.objectRedisTemplate == null) {
            this.objectRedisTemplate = template;
        }
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public void set(String key, String value, long timeout) {
        if (timeout == SaTokenDao.NEVER_EXPIRE) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, timeout, TimeUnit.SECONDS);
        }
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == SaTokenDao.NOT_VALUE_EXPIRE) {
            return;
        }
        this.set(key, value, expire);
    }

    public void delete(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    public long getTimeout(String key) {
        return this.stringRedisTemplate.getExpire((Object)key);
    }

    public void updateTimeout(String key, long timeout) {
        if (timeout == SaTokenDao.NEVER_EXPIRE) {
            long expire = this.getTimeout(key);
            if (expire != SaTokenDao.NEVER_EXPIRE) {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        this.stringRedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public Object getObject(String key) {
        return this.objectRedisTemplate.opsForValue().get((Object)key);
    }

    public void setObject(String key, Object object, long timeout) {
        if (timeout == SaTokenDao.NEVER_EXPIRE) {
            this.objectRedisTemplate.opsForValue().set((Object)key, object);
        } else {
            this.objectRedisTemplate.opsForValue().set((Object)key, object, timeout, TimeUnit.SECONDS);
        }
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        if (expire == SaTokenDao.NOT_VALUE_EXPIRE) {
            return;
        }
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        this.objectRedisTemplate.delete((Object)key);
    }

    public long getObjectTimeout(String key) {
        return this.objectRedisTemplate.getExpire((Object)key);
    }

    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == SaTokenDao.NEVER_EXPIRE) {
            long expire = this.getObjectTimeout(key);
            if (expire != SaTokenDao.NEVER_EXPIRE) {
                this.setObject(key, this.getObject(key), timeout);
            }
            return;
        }
        this.objectRedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public List<String> searchData(String prefix, String keyword, int start, int size) {
        Set keys = this.stringRedisTemplate.keys((Object)(prefix + "*" + keyword + "*"));
        ArrayList list = new ArrayList(keys);
        return SaTokenInsideUtil.searchList(list, (int)start, (int)size);
    }
}

