/*
 * Decompiled with CFR 0.152.
 */
package com.ab.uc.client.web.filter;

import com.ab.uc.client.web.dto.ClientAuthDto;
import com.ab.uc.client.web.dto.ClientTicket;
import com.ab.uc.client.web.dto.UserBaseInfo;
import com.ab.uc.client.web.filter.ClientSession;
import com.ab.uc.client.web.filter.SSOHandler;
import com.ab.uc.client.web.filter.exception.LoginCallbackException;
import com.ab.uc.client.web.service.ConnectionException;
import com.ab.uc.client.web.service.UCClient;
import com.ab.uc.client.web.service.UCException;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class LoginSuccessFilter
implements Filter {
    private static final Logger log = Logger.getLogger(LoginSuccessFilter.class);
    private String clientNo;
    private String clientKey;
    private String SSOServerUrl;
    private SSOHandler ssoHandler;

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getParameter("a_code") != null && !req.getParameter("a_code").equals("-1")) {
            ClientAuthDto authDto = new ClientAuthDto();
            authDto.setAuthCode(req.getParameter("a_code"));
            authDto.setClientNo(this.clientNo);
            authDto.setPassword(this.clientKey);
            try {
                ClientTicket ct = UCClient.getInstance(this.SSOServerUrl).clientAuthForSSO(authDto);
                UserBaseInfo user = UCClient.getInstance(this.SSOServerUrl).getUserInfo(ct.getTicket());
                this.ssoHandler.onLoginSuccess(req, res, ct, user);
                Cookie ctCookie = new Cookie("__ct__", ct.getTicket());
                ctCookie.setPath("/");
                ((HttpServletResponse)res).addCookie(ctCookie);
                HttpServletRequest request = (HttpServletRequest)req;
                if (this.ssoHandler.getSession(req) == null) {
                    request.getSession().setAttribute(ct.getTicket(), (Object)ct);
                } else {
                    ClientSession session = this.ssoHandler.getSession(req);
                    session.setAttribute(request, ct.getTicket(), ct);
                }
                String redirectUrl = req.getParameter("original_redirect_url");
                if (redirectUrl != null) {
                    ((HttpServletResponse)res).sendRedirect(redirectUrl);
                } else {
                    String authCode = req.getParameter("a_code");
                    String queryString = request.getQueryString();
                    String currentUrl = request.getRequestURL().toString();
                    if (queryString != null && !"".equals(queryString)) {
                        currentUrl = currentUrl + "?" + queryString;
                    }
                    currentUrl = currentUrl.replace("?a_code=" + authCode, "").replace("&a_code=" + authCode, "");
                    ((HttpServletResponse)res).sendRedirect(currentUrl);
                }
                return;
            }
            catch (UCException e) {
                log.error((Object)"Authcode auth failed", (Throwable)e);
            }
            catch (ConnectionException e) {
                log.error((Object)"uc is not reachable", (Throwable)e);
            }
            catch (LoginCallbackException e) {
                log.error((Object)"uc LoginCallbackException", (Throwable)e);
            }
        }
        chain.doFilter(req, res);
    }

    public void init(FilterConfig config) throws ServletException {
        String ssoHandlerClass = config.getServletContext().getInitParameter("SSO_HANDLER");
        if (ssoHandlerClass == null) {
            log.error((Object)"sso handler class is null");
            throw new ServletException("The 'SSO_HANDLER' parameter must be specified in web.xml");
        }
        try {
            this.ssoHandler = (SSOHandler)Class.forName(ssoHandlerClass).newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)("Can not init the ssohandler for class:" + ssoHandlerClass), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Can not init the ssohandler for class:" + ssoHandlerClass), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Can not init the ssohandler for class:" + ssoHandlerClass), (Throwable)e);
        }
        this.clientNo = config.getServletContext().getInitParameter("CLIENT_NO");
        this.clientKey = config.getServletContext().getInitParameter("CLIENT_KEY");
        this.SSOServerUrl = config.getServletContext().getInitParameter("SSO_SERVER_URL");
    }
}

