/*
 * Decompiled with CFR 0.152.
 */
package com.ab.uc.client.web.filter;

import com.ab.uc.client.web.filter.SSOHandler;
import com.ab.uc.client.web.service.ConnectionException;
import com.ab.uc.client.web.service.UCClient;
import com.ab.uc.client.web.service.UCException;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class LogoutFilter
implements Filter {
    private static final Logger log = Logger.getLogger(LogoutFilter.class);
    private String clientNo;
    private String clientKey;
    private String SSOServerUrl;
    private SSOHandler ssoHandler;

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            String clientTicket = this.getClientTicket((HttpServletRequest)req);
            if (clientTicket != null) {
                UCClient.getInstance(this.SSOServerUrl).logout(clientTicket);
                this.clearClientTicket((HttpServletResponse)res);
            }
        }
        catch (ConnectionException | UCException e) {
            e.printStackTrace();
        }
        chain.doFilter(req, res);
    }

    public void init(FilterConfig config) throws ServletException {
        String ssoHandlerClass = config.getServletContext().getInitParameter("SSO_HANDLER");
        if (ssoHandlerClass == null) {
            log.error((Object)"sso handler class is null");
            throw new ServletException("The 'SSO_HANDLER' parameter must be specified in web.xml");
        }
        try {
            this.ssoHandler = (SSOHandler)Class.forName(ssoHandlerClass).newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)("Can not init the ssohandler for class:" + ssoHandlerClass), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Can not init the ssohandler for class:" + ssoHandlerClass), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Can not init the ssohandler for class:" + ssoHandlerClass), (Throwable)e);
        }
        this.clientNo = config.getServletContext().getInitParameter("CLIENT_NO");
        this.clientKey = config.getServletContext().getInitParameter("CLIENT_KEY");
        this.SSOServerUrl = config.getServletContext().getInitParameter("SSO_SERVER_URL");
    }

    private String getClientTicket(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("__ct__")) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    private void clearClientTicket(HttpServletResponse response) {
        Cookie cookie = new Cookie("__ct__", null);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }
}

