/*
 * Decompiled with CFR 0.152.
 */
package com.ab.uc.client.web.filter;

import com.ab.uc.client.web.dto.ClientTicket;
import com.ab.uc.client.web.dto.RefreshClientTicketDto;
import com.ab.uc.client.web.filter.Constants;
import com.ab.uc.client.web.filter.SSOHandler;
import com.ab.uc.client.web.service.ConnectionException;
import com.ab.uc.client.web.service.UCClient;
import com.ab.uc.client.web.service.UCException;
import java.io.IOException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SSOFilter
implements Filter {
    private static final Logger log = Logger.getLogger(SSOFilter.class);
    private static final int CLIENT_TICKET_REFRESH_INTERVAL = 300000;
    private String SSOServerUrl;
    private String clientNo;
    private String clientKey;
    private SSOHandler ssoHandler;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String clientTicket = this.getClientTicket(request);
        if (!this.ssoHandler.needCheck(req, res) || req.getParameter("a_code") != null) {
            chain.doFilter(req, res);
            return;
        }
        ClientTicket ct = null;
        ct = this.ssoHandler.getSession(req) == null ? (ClientTicket)request.getSession().getAttribute(clientTicket) : (ClientTicket)this.ssoHandler.getSession(req).getAttribute(request, clientTicket);
        if (clientTicket == null || ct == null) {
            this.clearClientTicket((HttpServletResponse)res);
            this.ssoHandler.onTokenCheckFailed(req, res, chain, Constants.TOKEN_CHECK_FAILED_CODE.NO_TOKEN);
            return;
        }
        Date expireTime = ct.getExpireTime();
        Date now = new Date();
        if (now.getTime() > expireTime.getTime()) {
            this.clearClientTicket((HttpServletResponse)res);
            this.ssoHandler.onTokenCheckFailed(req, res, chain, Constants.TOKEN_CHECK_FAILED_CODE.INVALIDATED);
            return;
        }
        if (now.getTime() + 300000L > expireTime.getTime()) {
            RefreshClientTicketDto dto = new RefreshClientTicketDto();
            dto.setClientNo(this.clientNo);
            dto.setClientKey(this.clientKey);
            dto.setTicket(ct.getTicket());
            try {
                ct = UCClient.getInstance(this.SSOServerUrl).refreshClientTicket(dto);
                if (ct == null) {
                    this.clearClientTicket((HttpServletResponse)res);
                    this.ssoHandler.onTokenCheckFailed(req, res, chain, Constants.TOKEN_CHECK_FAILED_CODE.INVALIDATED);
                    return;
                }
                if (this.ssoHandler.getSession(req) == null) {
                    request.getSession().setAttribute(clientTicket, (Object)ct);
                } else {
                    this.ssoHandler.getSession(req).setAttribute(request, clientTicket, ct);
                }
            }
            catch (UCException e) {
                log.error((Object)"can't refresh the client ticket", (Throwable)e);
                this.ssoHandler.onTokenCheckFailed(req, res, chain, Constants.TOKEN_CHECK_FAILED_CODE.UNCONNECTED);
                return;
            }
            catch (ConnectionException e) {
                log.error((Object)"can't refresh the client ticket", (Throwable)e);
                this.ssoHandler.onTokenCheckFailed(req, res, chain, Constants.TOKEN_CHECK_FAILED_CODE.UNCONNECTED);
                return;
            }
        }
        this.ssoHandler.validateClientSession(req, res, chain);
    }

    public void init(FilterConfig config) throws ServletException {
        String ssoHandlerClass = config.getServletContext().getInitParameter("SSO_HANDLER");
        if (ssoHandlerClass == null) {
            log.error((Object)"sso handler class is null");
            throw new ServletException("The 'SSO_HANDLER' parameter must be specified in web.xml");
        }
        try {
            this.ssoHandler = (SSOHandler)Class.forName(ssoHandlerClass).newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)("Can not init the ssohandler for class:" + ssoHandlerClass), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Can not init the ssohandler for class:" + ssoHandlerClass), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Can not init the ssohandler for class:" + ssoHandlerClass), (Throwable)e);
        }
        this.clientNo = config.getServletContext().getInitParameter("CLIENT_NO");
        this.SSOServerUrl = config.getServletContext().getInitParameter("SSO_SERVER_URL");
        this.clientKey = config.getServletContext().getInitParameter("CLIENT_KEY");
    }

    public void destroy() {
    }

    private String getClientTicket(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("__ct__")) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    private void clearClientTicket(HttpServletResponse response) {
        Cookie cookie = new Cookie("__ct__", null);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }
}

