/*
 * Decompiled with CFR 0.152.
 */
package com.ab.uc.client.web.service;

import com.ab.uc.client.web.service.ClientException;
import com.ab.uc.client.web.service.HttpResponse;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BasicClient {
    private static String CHARSET = "UTF-8";
    private String serverUrl;
    protected static final Logger log = Logger.getLogger(BasicClient.class);

    public BasicClient(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse execute(String url, Map<String, String> headers, String httpMethod, String body) throws ClientException, IOException {
        HttpURLConnection connection = null;
        try {
            URL address_url = new URL(this.serverUrl + url);
            connection = (HttpURLConnection)address_url.openConnection();
            connection.setRequestMethod(httpMethod);
            if (headers != null) {
                for (Map.Entry<String, String> m : headers.entrySet()) {
                    connection.addRequestProperty(m.getKey(), m.getValue());
                }
            }
            connection.addRequestProperty("Connection", "close");
            connection.addRequestProperty("Content-Type", "application/json");
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            if (body != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("request body:" + body));
                }
                DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                out.write(body.getBytes(Charset.forName(CHARSET)));
                out.flush();
                out.close();
            }
            int response_code = connection.getResponseCode();
            if (log.isDebugEnabled()) {
                log.debug((Object)("response code:" + response_code));
            }
            InputStream in = null;
            in = response_code == 200 ? connection.getInputStream() : connection.getErrorStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, CHARSET));
            String line = null;
            String content = "";
            while ((line = reader.readLine()) != null) {
                content = content + line;
            }
            if (content != null && log.isDebugEnabled()) {
                log.debug((Object)("response content:" + content));
            }
            if (response_code != 200) {
                throw new ClientException(response_code, content);
            }
            HttpResponse response = new HttpResponse();
            response.setBody(content);
            response.setHeaders(connection.getHeaderFields());
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public String getRequestBodyFromFile(String fileName) throws IOException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = null;
        String content = "";
        while ((line = reader.readLine()) != null) {
            content = content + line;
        }
        return content;
    }

    public HttpResponse post(String url, String body) throws ClientException, IOException {
        return this.post(url, null, body);
    }

    public HttpResponse put(String url, String body) throws ClientException, IOException {
        return this.put(url, null, body);
    }

    public HttpResponse delete(String url) throws ClientException, IOException {
        return this.delete(url, null);
    }

    public HttpResponse get(String url) throws ClientException, IOException {
        return this.get(url, null);
    }

    public HttpResponse post(String url, Map<String, String> headers, String body) throws ClientException, IOException {
        return this.execute(url, headers, "POST", body);
    }

    public HttpResponse put(String url, Map<String, String> headers, String body) throws ClientException, IOException {
        return this.execute(url, headers, "PUT", body);
    }

    public HttpResponse delete(String url, Map<String, String> headers) throws ClientException, IOException {
        return this.execute(url, headers, "DELETE", null);
    }

    public HttpResponse get(String url, Map<String, String> headers) throws ClientException, IOException {
        return this.execute(url, headers, "GET", null);
    }
}

