/*
 * Decompiled with CFR 0.152.
 */
package com.ab.uc.client.web.service;

import com.ab.uc.client.web.dto.ClientAuthDto;
import com.ab.uc.client.web.dto.ClientTicket;
import com.ab.uc.client.web.dto.RefreshClientTicketDto;
import com.ab.uc.client.web.dto.UserBaseInfo;
import com.ab.uc.client.web.service.BasicClient;
import com.ab.uc.client.web.service.ClientException;
import com.ab.uc.client.web.service.ConnectionException;
import com.ab.uc.client.web.service.DateDeserializer;
import com.ab.uc.client.web.service.DateSerializer;
import com.ab.uc.client.web.service.ErrorResponse;
import com.ab.uc.client.web.service.HttpResponse;
import com.ab.uc.client.web.service.UCException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Date;

public class UCClient
extends BasicClient {
    private static UCClient ucClient;

    private UCClient(String serverUrl) {
        super(serverUrl);
    }

    public static UCClient getInstance(String serverUrl) {
        if (ucClient == null) {
            if (serverUrl.endsWith("/")) {
                serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
            }
            ucClient = new UCClient(serverUrl);
        }
        return ucClient;
    }

    public ClientTicket refreshClientTicket(RefreshClientTicketDto refreshClientTicketDto) throws UCException, ConnectionException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateSerializer()).setDateFormat(1);
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateDeserializer()).setDateFormat(1);
        Gson gson = gsonBuilder.create();
        try {
            HttpResponse response = this.post("/v2/refresh_client_ticket", gson.toJson((Object)refreshClientTicketDto));
            ClientTicket result = (ClientTicket)gson.fromJson(response.getBody(), ClientTicket.class);
            return result;
        }
        catch (ClientException e) {
            this.exceptionHandler(gson, e);
            return null;
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to connect user center:" + e.getMessage(), e);
        }
    }

    public ClientTicket clientAuthForSSO(ClientAuthDto clientAuthDto) throws UCException, ConnectionException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateSerializer()).setDateFormat(1);
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateDeserializer()).setDateFormat(1);
        Gson gson = gsonBuilder.create();
        try {
            HttpResponse response = this.post("/v2/client_auth_sso", gson.toJson((Object)clientAuthDto));
            ClientTicket result = (ClientTicket)gson.fromJson(response.getBody(), ClientTicket.class);
            return result;
        }
        catch (ClientException e) {
            this.exceptionHandler(gson, e);
            return null;
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to connect user center:" + e.getMessage(), e);
        }
    }

    public UserBaseInfo getUserInfo(String clientTicket) throws UCException, ConnectionException {
        Gson gson = new Gson();
        try {
            HttpResponse response = this.get("/v2/getUserBaseInfo/" + clientTicket);
            UserBaseInfo result = (UserBaseInfo)gson.fromJson(response.getBody(), UserBaseInfo.class);
            return result;
        }
        catch (ClientException e) {
            this.exceptionHandler(gson, e);
            return null;
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to connect user center:" + e.getMessage(), e);
        }
    }

    public void logout(String clientTicket) throws UCException, ConnectionException {
        Gson gson = new Gson();
        try {
            this.get("/v2/logout/" + clientTicket);
        }
        catch (ClientException e) {
            this.exceptionHandler(gson, e);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to connect user center:" + e.getMessage(), e);
        }
    }

    private void exceptionHandler(Gson gson, ClientException e) throws UCException {
        if (e.getResposneStatus() == 404) {
            throw new UCException("system error", e);
        }
        if (e.getResposneStatus() == 401) {
            throw new UCException(String.valueOf(e.getResposneStatus()), "Auth failed");
        }
        if (e.getBody() != null && !e.getBody().equals("")) {
            String body = e.getBody();
            ErrorResponse response = (ErrorResponse)gson.fromJson(body, ErrorResponse.class);
            throw new UCException(response.getCode(), response.getDescription());
        }
        throw new UCException(e.getMessage(), e);
    }
}

