/*
 * Decompiled with CFR 0.152.
 */
package com.ab.uc.client.web.servlet;

import com.ab.uc.client.web.dto.ClientTicket;
import com.ab.uc.client.web.dto.RefreshClientTicketDto;
import com.ab.uc.client.web.dto.UserBaseInfo;
import com.ab.uc.client.web.filter.LoginSuccessFilter;
import com.ab.uc.client.web.filter.SSOHandler;
import com.ab.uc.client.web.filter.exception.LoginCallbackException;
import com.ab.uc.client.web.service.ConnectionException;
import com.ab.uc.client.web.service.UCClient;
import com.ab.uc.client.web.service.UCException;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class BridgeAppToWebServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(LoginSuccessFilter.class);
    private String clientNo;
    private String clientKey;
    private String SSOServerUrl;
    private SSOHandler ssoHandler;

    public void init(ServletConfig config) throws ServletException {
        String ssoHandlerClass = config.getServletContext().getInitParameter("SSO_HANDLER");
        if (ssoHandlerClass == null) {
            log.error((Object)"sso handler class is null");
            throw new ServletException("The 'SSO_HANDLER' parameter must be specified in web.xml");
        }
        try {
            this.ssoHandler = (SSOHandler)Class.forName(ssoHandlerClass).newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)("Can not init the ssohandler for class:" + ssoHandlerClass), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Can not init the ssohandler for class:" + ssoHandlerClass), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Can not init the ssohandler for class:" + ssoHandlerClass), (Throwable)e);
        }
        this.clientNo = config.getServletContext().getInitParameter("CLIENT_NO");
        this.clientKey = config.getServletContext().getInitParameter("CLIENT_KEY");
        this.SSOServerUrl = config.getServletContext().getInitParameter("SSO_SERVER_URL");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String clientTicket = request.getParameter("ticket");
        String clientKey = request.getParameter("clientKey");
        String clientNo = request.getParameter("clientNo");
        String redirectUrl = request.getParameter("redirectUrl");
        if (clientTicket != null) {
            try {
                RefreshClientTicketDto refreshClientTicketDto = new RefreshClientTicketDto();
                refreshClientTicketDto.setClientKey(clientKey);
                refreshClientTicketDto.setClientNo(clientNo);
                refreshClientTicketDto.setTicket(clientTicket);
                ClientTicket ct = UCClient.getInstance(this.SSOServerUrl).refreshClientTicket(refreshClientTicketDto);
                UserBaseInfo user = UCClient.getInstance(this.SSOServerUrl).getUserInfo(ct.getTicket());
                this.ssoHandler.onLoginSuccess((ServletRequest)request, (ServletResponse)response, ct, user);
                Cookie ctCookie = new Cookie("__ct__", ct.getTicket());
                ctCookie.setPath("/");
                response.addCookie(ctCookie);
                if (this.ssoHandler.getSession((ServletRequest)request) == null) {
                    request.getSession().setAttribute(ct.getTicket(), (Object)ct);
                } else {
                    request.getSession().setAttribute(ct.getTicket(), (Object)ct);
                }
                redirectUrl = URLDecoder.decode(redirectUrl, "UTF-8");
                response.sendRedirect(redirectUrl);
                return;
            }
            catch (UCException e) {
                log.error((Object)"Authcode auth failed", (Throwable)e);
            }
            catch (ConnectionException e) {
                log.error((Object)"uc is not reachable", (Throwable)e);
            }
            catch (LoginCallbackException e) {
                e.printStackTrace();
            }
        }
    }
}

