import com.rapid.j2ee.framework.core.utils.TypeChecker;

/**
 * Ognl工具类，主要是为了在ognl表达式访问静态方法时可以减少长长的类名称编写 Ognl访问静态方法的表达式为:
 * 
 * @class@method(args)
 * 
 * 示例使用:
 * 
 * <pre>
 *      &lt;if test=&quot;@Ognl@isNotEmpty(userId)&quot;&gt;
 *              and user_id = #{userId}
 *      &lt;/if&gt;
 * </pre>
 * 
 * @author badqiu
 * 
 */
public class Ognl {

	private Ognl() {
	}

	public static boolean isEmpty(Object obj) {

		return TypeChecker.isEmptyObject(obj);
	}

	public static boolean isNotEmpty(Object o) {
		return !isEmpty(o);
	}

	public static boolean isNotBlank(Object o) {
		return !isBlank(o);
	}

	public static boolean isNumber(Object o) {
		if (o == null) {
			return false;
		}
		if (o instanceof Number) {
			return true;
		}

		if (o instanceof String) {
			try {
				Double.parseDouble((String) o);
				return true;
			} catch (NumberFormatException e) {
				return false;
			}
		}

		return false;
	}

	public static boolean isBlank(Object o) {
		if (o == null)
			return true;
		if (o instanceof String) {
			String str = (String) o;
			return isBlank(str);
		}
		return false;
	}

	public static boolean isBlank(String str) {

		if (str == null || str.length() == 0) {
			return true;
		}

		for (int i = 0; i < str.length(); i++) {
			if (!Character.isWhitespace(str.charAt(i))) {
				return false;
			}
		}
		return true;
	}

}
