import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

/**
 * Ognl工具类，主要是为了在ognl表达式访问静态方法时可以减少长长的类名称编写 Ognl访问静态方法的表达式为:
 * 
 * @class@method(args)
 * 
 * 示例使用:
 * 
 * <pre>
 *      &lt;if test=&quot;@Ognl@isNotEmpty(userId)&quot;&gt;
 *              and user_id = #{userId}
 *      &lt;/if&gt;
 * </pre>
 * 
 * @author badqiu
 * 
 */
public class OgnlStruts {

	private OgnlStruts() {
	}

	public static boolean isEmpty(String exp) {

		return TypeChecker.isEmptyObject(ActionContextUtils.getValueStack()
				.findValue(exp));
	}

	public static boolean isNotEmpty(String exp) {
		return !isEmpty(exp);
	}

	public static boolean isNotBlank(String exp) {
		return !isBlank(exp);
	}

	public static boolean isNumber(String exp) {

		Object o = ActionContextUtils.getValueStack().findValue(exp);

		return TypeChecker.isNumber(o);
	}

	public static boolean isBlank(String exp) {
		Object o = ActionContextUtils.getValueStack().findValue(exp);
		if (o == null)
			return true;
		if (o instanceof String) {
			String str = (String) o;
			return _isBlankStringValue(str);
		}
		return false;
	}

	public static boolean _isBlankStringValue(String str) {

		if (str == null || str.length() == 0) {
			return true;
		}

		for (int i = 0; i < str.length(); i++) {
			if (!Character.isWhitespace(str.charAt(i))) {
				return false;
			}
		}
		return true;
	}

}
