package com.rapid.im.framework.network.configure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

import com.rapid.im.framework.network.configure.domain.NetConfigurer;
import com.rapid.im.framework.network.configure.domain.NetFunction;
import com.rapid.im.framework.network.configure.domain.NetParameter;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.io.xml.XPathParser;
import com.rapid.j2ee.framework.core.io.xml.XmlPaserJavaBean;
import com.rapid.j2ee.framework.core.utils.CollectionsUtil;
import com.rapid.j2ee.framework.core.utils.ResourceUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class NetConfigurerResourceParser implements InitializingBean {

	public NetConfigurerResourceParser() {
		this("im/weixin/*.xml");
	}

	public NetConfigurerResourceParser(String xmlPath) {
		this.xmlPath = xmlPath;
		netConfigurer = new NetConfigurer();
	}

	public void digest() {

		try {

			if (!hasConfigurerResourceChange()) {
				return;
			}

			for (Resource resource : getXmlResources()) {

				this.digestResource(resource);

			}

			this.bindNetHandlers();

			this.resolveDynamicPlaceholder();

		} catch (Throwable e) {

			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

		System.out.println(netConfigurer);
	}

	private boolean hasConfigurerResourceChange() {

		long lastChangedTime = 0;

		List<Resource> resources = this.getXmlResources();

		for (Resource resource : resources) {

			try {
				lastChangedTime = Math.max(lastChangedTime, resource.getFile()
						.lastModified());

			} catch (Exception e) {

			}

		}

		if (lastChangedTime == lastConfigureChangedTime) {
			return false;
		}

		lastConfigureChangedTime = lastChangedTime;

		return true;
	}

	private List<Resource> getXmlResources() {

		Resource[] resourceArray = ResourceUtils.getResources(xmlPath);

		List<Resource> resources = new ArrayList<Resource>(resourceArray.length);

		for (Resource resource : resourceArray) {

			if (!resource.getFilename().startsWith(this.imApplicationName)) {
				continue;
			}

			System.out.println(resource);

			resources.add(resource);

		}

		return resources;
	}

	private void digestResource(Resource xmlResource) throws Throwable {

		XPathParser xPathParser = new XPathParser(xmlResource.getInputStream(),
				Charsets.UTF_8.getCharset());

		XmlPaserJavaBean<NetConfigurer> parser = new XmlPaserJavaBean<NetConfigurer>(
				xPathParser, NetConfigurer.class);

		netConfigurer.addNetConfigurer(parser.resolve());

	}

	private void bindNetHandlers() {

		for (NetFunction netFunction : netConfigurer.getNetFunctions()) {

			Assert
					.isTrue(CollectionsUtil.exists(netConfigurer
							.getNetHandlers(), "id", netFunction
							.getNetFunctionRequest().getSenderId()),
							"Please setup a handler id:"
									+ netFunction.getNetFunctionRequest()
											.getSenderId());

			netFunction.getNetFunctionRequest().setNetHandler(
					CollectionsUtil.findOne(netConfigurer.getNetHandlers(),
							"id", netFunction.getNetFunctionRequest()
									.getSenderId()));

			Assert.isTrue(CollectionsUtil.exists(
					netConfigurer.getNetHandlers(), "id", netFunction
							.getNetFunctionResponse().getParserId()),
					"Please setup a handler id:"
							+ netFunction.getNetFunctionResponse()
									.getParserId());

			netFunction.getNetFunctionResponse().setNetHandler(
					CollectionsUtil.findOne(netConfigurer.getNetHandlers(),
							"id", netFunction.getNetFunctionResponse()
									.getParserId()));

		}
	}

	private void resolveDynamicPlaceholder() {

		// Resolve Parameter Url

		for (NetFunction netFunction : netConfigurer.getNetFunctions()) {

			resolveDynamicPlaceholderForParameters(netFunction
					.getNetFunctionRequest().getNetParameters());
		}

	}

	private void resolveDynamicPlaceholderForParameters(
			List<NetParameter> parameters) {

		if (TypeChecker.isEmpty(parameters)) {
			return;
		}

		for (NetParameter netParameter : parameters) {

			String[] dValues = StringUtils.splitRestrictClosure(netParameter
					.getValue(), "${", "}");

			if (TypeChecker.isEmpty(dValues)) {
				continue;
			}

			Map<String, String> dynamicValues = new HashMap<String, String>();

			for (String dValue : dValues) {
				dynamicValues.put(dValue, this.resolve(dValue));
			}

			netParameter.setValue(StringUtils.replaceAll(netParameter
					.getValue(), dynamicValues, "${", "}"));
		}

	}

	private String resolve(String dynamicKey) {

		if (!dynamicKey.startsWith("WebSite")) {
			throw new IllegalArgumentException("Cannot Replace Dynamic Key:"
					+ dynamicKey);
		}

		return netConfigurer.getNetWebisteByType(
				StringUtils.substringAfter(dynamicKey, ".")).getHome();
	}

	public void setXmlConfigurerPath(String xmlPath) {
		this.xmlPath = xmlPath;
	}

	public NetConfigurer getNetConfigurer() {

		digest();

		return netConfigurer;
	}

	public void setImApplicationName(String imApplicationName) {
		this.imApplicationName = imApplicationName;
	}

	public String getImApplicationName() {
		return imApplicationName;
	}

	public void afterPropertiesSet() throws Exception {

		Assert.hasLength(this.xmlPath, "Please setup im application xml path!");

		Assert.hasLength(this.imApplicationName,
				"Please setup im application name!");

		this.digest();

	}

	private String xmlPath;

	private long lastConfigureChangedTime = -1;

	private NetConfigurer netConfigurer;

	private String imApplicationName;

	public static void main(String[] args) {

		NetConfigurerResourceParser parser = new NetConfigurerResourceParser(
				"im/weixin/*.xml");
		parser.setImApplicationName("WeiXin");
		try {
			parser.afterPropertiesSet();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

}
