package com.rapid.im.framework.network.configure.domain;

import java.util.List;

import com.rapid.j2ee.framework.core.io.xml.XPathTagBean;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.CollectionsUtil;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class NetAbstractFunctionParameters {

	@XPathTagBean("parameters/parameter")
	private List<NetParameter> netParameters;

	public List<NetParameter> getNetParameters() {
		return netParameters;
	}

	public NetParameter getNetParameterByName(String name) {

		NetParameter netParameter = CollectionsUtil.findOne(
				netParameters, "name", name);

		if (TypeChecker.isNull(netParameter)) {
			return (NetParameter) ConstructorUtils
					.newCacheInstance(NetParameter.class);
		}

		return netParameter;
	}

	public String getNetParameterValueByName(String name) {

		return StringUtils.trimToEmpty(getNetParameterByName(name)
				.getValue());
	}
}
