package com.rapid.im.framework.network.configure.domain;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import org.springframework.util.Assert;

import com.rapid.im.framework.network.constants.NetFunctionCategory;
import com.rapid.im.framework.network.constants.NetWebisteType;
import com.rapid.j2ee.framework.core.io.xml.XPathTagBean;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.CollectionsUtil;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;



public class NetConfigurer {

	/**
	 * Net Website 列表
	 */
	@XPathTagBean("configure/websites/website")
	private List<NetWebiste> netWebsites;

	@XPathTagBean("configure/applications/application")
	private List<NetApplication> netApplications;

	@XPathTagBean("configure/handlers/handler")
	private List<NetHandler> netHandlers;

	@XPathTagBean("configure/functions/function")
	private List<NetFunction> netFunctions;

	public NetApplication getNetApplicationByCode(String applicationCode) {

		NetApplication netApplication = CollectionsUtil.findOne(
				netApplications, "applicationCode", applicationCode);

		Assert.isTrue(netApplication != null,
				"Cannot find Net Application By Code " + applicationCode);

		return netApplication;
	}

	public NetWebiste getNetWebisteByType(String type) {

		NetWebiste netWebiste = CollectionsUtil.findOne(netWebsites, "type",
				NetWebisteType.getType(type).getType());

		Assert.isTrue(netWebiste != null,
				"Cannot find Net Website By type " + type);

		return netWebiste;
	}

	public NetHandler getNetHandlerById(String id) {

		NetHandler netHandler = CollectionsUtil.findOne(netHandlers, "id",
				id);

		Assert.isTrue(netHandler != null,
				"Cannot find Net handler By id " + id);

		return netHandler;
	}

	public void addNetConfigurer(NetConfigurer netConfigurer) {

		for (Field field : ClassUtils.getFieldsByType(this.getClass(),
				List.class)) {

			List items = (List) InvokeUtils.getFieldValue(this, field);

			if (TypeChecker.isNull(items) || items == ObjectUtils.EMPTY_LIST) {

				items = new ArrayList();
			}

			List values = (List) InvokeUtils.getFieldValue(netConfigurer,
					field);

			if (!TypeChecker.isNull(values)) {
				items.addAll(values);
			}

			InvokeUtils.setField(this, field.getName(), items);

		}
	}

	public NetFunction getNetFunction(NetFunctionCategory category) {

		NetFunction netFunction = CollectionsUtil.findOne(this.netFunctions,
				"categoryFunctionKey", category.getCategoryFunctionKey());

		Assert.isTrue(netFunction != null,
				"Cannot find Net Function By category " + category);

		return netFunction;

	}

	public List<NetApplication> getNetApplications() {
		return netApplications;
	}

	public List<NetFunction> getNetFunctions() {
		return netFunctions;
	}

	public List<NetHandler> getNetHandlers() {
		return netHandlers;
	}

	public List<NetWebiste> getNetWebsites() {
		return netWebsites;
	}

	public String toString() {
		return ObjectAnalyzer.toString(this);
	}

}
