package com.rapid.im.framework.network.executor;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;

import com.rapid.im.framework.network.configure.*;
import com.rapid.im.framework.network.configure.domain.*;
import com.rapid.im.framework.network.executor.parameter.*;
import com.rapid.im.framework.network.executor.servlet.NetFunctionAbstractRequester;
import com.rapid.im.framework.network.executor.servlet.NetFunctionAbstractResponser;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.spring.SpringApplicationContextHolder;
import com.rapid.j2ee.framework.core.utils.CollectionsUtil;
import com.rapid.j2ee.framework.core.utils.MapUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class NetFunctionGenericExecutor implements NetFunctionExecutor {

	public NetFunctionGenericExecutor() {

	}

	public Object execute(NetFunctionRequestPreparement requestPreparement) {
		return execute("", requestPreparement);
	}

	public Object execute(String applicationCode,
			NetFunctionRequestPreparement requestPreparement) {

		NetFunction NetFunction = netConfigurerResourceParser
				.getNetConfigurer().getNetFunction(
						requestPreparement.getNetFunctionCategory());

		if (!TypeChecker.isEmpty(applicationCode)) {

			requestPreparement.addUrlParameter(netConfigurerResourceParser
					.getNetConfigurer()
					.getNetApplicationByCode(applicationCode));
		}

		NetFunctionAbstractRequester netFunctionAbstractRequester = null;

		try {
			netFunctionAbstractRequester = ((NetFunctionAbstractRequester) ConstructorUtils
					.newInstance(NetFunction.getNetFunctionRequest()
							.getNetHandler().getType(),
							NetFunctionAbstractRequester.Constructor_Classes,
							new Object[] {
									netConfigurerResourceParser
											.getNetConfigurer(),
									NetFunction.getNetFunctionRequest() }));

			// Send Request
			Object returnResult = netFunctionAbstractRequester
					.send(requestPreparement);

			// Parser..

			return ((NetFunctionAbstractResponser) ConstructorUtils
					.newInstance(NetFunction.getNetFunctionResponse()
							.getNetHandler().getType(),
							NetFunctionAbstractResponser.Constructor_Classes,
							new Object[] {
									netConfigurerResourceParser
											.getNetConfigurer(),
									NetFunction.getNetFunctionResponse() }))
					.parse(returnResult, requestPreparement);
		} finally {
			netFunctionAbstractRequester.release();
		}

	}

	public void setNetConfigurerResourceParser(
			NetConfigurerResourceParser netConfigurerResourceParser) {
		this.netConfigurerResourceParser = netConfigurerResourceParser;
	}

	public NetApplication getNetApplication(String applicationCode) {
		return netConfigurerResourceParser.getNetConfigurer()
				.getNetApplicationByCode(applicationCode);
	}

	@Autowired
	private NetConfigurerResourceParser netConfigurerResourceParser;

	public static void main(String[] args) {

		NetConfigurerResourceParser parser = new NetConfigurerResourceParser(
				"Net/*.xml");

		NetFunctionGenericExecutor executor = new NetFunctionGenericExecutor();

		executor.setNetConfigurerResourceParser(parser);

		// Map<String, String> requestMap = new HashMap<String, String>();
		// requestMap.put("appid", value);
		//
		// executor.execute(NetFunctionCategory.BasicSupport_AccessToken,
		// requestMap);

	}
}
