package com.rapid.im.framework.network.executor.parameter;

import java.util.Map;

import com.rapid.im.framework.network.configure.domain.NetAbstractFunctionParameters;
import com.rapid.im.framework.network.configure.domain.NetParameter;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class NetAbstractParameterResolver implements
		NetParameterResolver {

	public static NetParameterResolver getNetParameterResolver(
			NetParameter parameter) {

		return (NetParameterResolver) ConstructorUtils
				.newCacheInstance(NetAbstractParameterResolver.class
						.getPackage().getName()
						+ "."
						+ "Net"
						+ StringUtils.upperStartChar(parameter.getType()
								.toLowerCase()) + "ParameterResolver");
	}

	public String resolve(NetAbstractFunctionParameters parameters,
			NetParameter parameter, Map<String, ?> value) {

		if (TypeChecker.isEmpty(parameter.getValue())) {
			return "";
		}

		return doResolve(parameters, parameter, value);
	}

	protected abstract String doResolve(
			NetAbstractFunctionParameters parameters, NetParameter parameter,
			Map<String, ?> value);

}
