package com.rapid.im.framework.network.executor.parameter;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import com.rapid.im.framework.network.constants.NetFunctionCategory;
import com.rapid.im.framework.weixin.basic.domain.WeiXinSecurityToken;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;

public class NetFunctionRequestPreparement {

	public NetFunctionRequestPreparement(NetFunctionCategory category) {
		this.category = category;
		urlParameters = new HashMap<String, Object>();

		contentParameters = new HashMap<String, Object>(3);
	}

	public void addUrlParameter(String key, Object value) {
		urlParameters.put(key, value);
	}

	public void addAccessToken(String token) {

		addUrlParameter(Parameter_Access_Token_Name, token);
	}

	public void addAccessToken(WeiXinSecurityToken weiXinSecurityToken) {

		this.addUrlParameter(weiXinSecurityToken);
	}

	public Map<String, Object> getUrlParameters() {
		return urlParameters;
	}

	public void addUrlParameter(Object bean) {
		urlParameters.putAll(ObjectUtils.convertBeanFieldValueMap(bean));
	}

	public void addContentParameter(String key, Object value) {
		contentParameters.put(key, value);
	}

	public void addContentParameter(Object bean) {
		urlParameters.putAll(ObjectUtils.convertBeanFieldValueMap(bean));
	}

	public void addContentMediaResource(File mediaResource) {
		this.mediaResource = mediaResource;
	}

	public File getContentMediaResource() {
		return mediaResource;
	}

	public NetFunctionCategory getNetFunctionCategory() {
		return category;
	}

	public Map<String, Object> getContentParameters() {
		return contentParameters;
	}

	private NetFunctionCategory category;

	private Map<String, Object> contentParameters;

	private Map<String, Object> urlParameters;

	private File mediaResource;

	public static final String Parameter_Access_Token_Name = "access_token";

}
