package com.rapid.im.framework.network.executor.servlet;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import com.rapid.im.framework.network.configure.domain.*;
import com.rapid.im.framework.network.executor.parameter.NetAbstractParameterResolver;
import com.rapid.im.framework.network.executor.parameter.NetFunctionRequestPreparement;
import com.rapid.j2ee.framework.core.utils.MessagetFormatUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;



public abstract class NetFunctionAbstractRequester {

	public NetFunctionAbstractRequester(NetConfigurer netConfigurer,
			NetFunctionRequest netFunctionRequest) {

		this.netConfigurer = netConfigurer;

		this.netFunctionRequest = netFunctionRequest;

	}

	public Object send(NetFunctionRequestPreparement requestPreparement) {

		return this.doSend(resolveParameterValue(this.netFunctionRequest
				.getNetParameterByName(Request_URL_Parameter_Name),
				requestPreparement.getUrlParameters()), resolveParameterValue(
				this.netFunctionRequest
						.getNetParameterByName(Request_Body_Parameter_Name),
				requestPreparement.getContentParameters()),
				netFunctionRequest, requestPreparement);
	}

	protected String resolveParameterValue(NetParameter parameter,
			Map<String, ?> value) {

		return NetAbstractParameterResolver.getNetParameterResolver(
				parameter).resolve(netFunctionRequest, parameter, value);
	}

	protected abstract Object doSend(String url, String body,
			NetFunctionRequest netFunctionRequest,
			NetFunctionRequestPreparement requestPreparement);
	
	public void release(){
		
	}

	protected NetConfigurer netConfigurer;

	protected NetFunctionRequest netFunctionRequest;

	public static final Class[] Constructor_Classes = new Class[] {
			NetConfigurer.class, NetFunctionRequest.class };

	public static final String Request_URL_Parameter_Name = "Url";

	public static final String Request_Body_Parameter_Name = "Body";

	public static void main(String[] args) {
		System.out
				.println(Arrays
						.toString(StringUtils
								.splitClosure(
										"${WebSiteBasic}/cgi-bin/token?grant_type=client_credential&appid={appid}&secret={secret}",
										"${", "}")));
	}

}
