package com.rapid.im.framework.network.executor.servlet;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import com.rapid.im.framework.network.configure.domain.NetConfigurer;
import com.rapid.im.framework.network.configure.domain.NetFunctionResponse;
import com.rapid.im.framework.network.executor.parameter.NetFunctionRequestPreparement;
import com.rapid.j2ee.framework.core.utils.MessagetFormatUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;

public abstract class NetFunctionAbstractResponser<T> {

	public NetFunctionAbstractResponser(NetConfigurer netConfigurer,
			NetFunctionResponse netFunctionResponse) {

		this.netConfigurer = netConfigurer;

		this.netFunctionResponse = netFunctionResponse;
	}

	public Object parse(T requestReturnValue,
			NetFunctionRequestPreparement requestPreparement) {

		return this.doParse(netFunctionResponse
				.getNetParameterValueByName(Response_Parameter_Class_Name),
				requestReturnValue, netFunctionResponse, requestPreparement);
	}

	protected abstract Object doParse(String className, T requestReturnValue,
			NetFunctionResponse netFunctionResponse,
			NetFunctionRequestPreparement requestPreparement);

	protected NetConfigurer netConfigurer;

	protected NetFunctionResponse netFunctionResponse;

	public static final Class[] Constructor_Classes = new Class[] {
			NetConfigurer.class, NetFunctionResponse.class };

	public static final String Response_Parameter_Class_Name = "Class";

	public static void main(String[] args) {
		System.out
				.println(Arrays
						.toString(StringUtils
								.splitClosure(
										"${WebSiteBasic}/cgi-bin/token?grant_type=client_credential&appid={appid}&secret={secret}",
										"${", "}")));
	}

}
