package com.rapid.im.framework.network.executor.servlet;

import java.util.List;
import java.util.Map;

import com.rapid.im.framework.network.configure.domain.NetConfigurer;
import com.rapid.im.framework.network.configure.domain.NetFunctionRequest;
import com.rapid.im.framework.network.executor.parameter.NetFunctionRequestPreparement;
import com.rapid.j2ee.framework.core.io.http.HttpGetClient;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class NetFunctionHttpGetRequester extends NetFunctionAbstractRequester {

	public NetFunctionHttpGetRequester(NetConfigurer netConfigurer,
			NetFunctionRequest netFunctionRequest) {
		super(netConfigurer, netFunctionRequest);

	}

	@Override
	protected Object doSend(String url, String requestContent,
			NetFunctionRequest netFunctionRequest,
			NetFunctionRequestPreparement request) {

		System.out.println("url:" + url.trim());

		httpGetClient = new HttpGetClient(url);

		if (TypeChecker.isSpecialTrue(netFunctionRequest
				.getNetParameterValueByName("ResponseEntity"))) {
			return httpGetClient.execute();
		}

		return httpGetClient.executeContent();
	}

	@Override
	public void release() {

		try {
			httpGetClient.shutdown();
		} catch (Exception e) {

		}
	}

	private HttpGetClient httpGetClient = null;

}
