package com.rapid.im.framework.network.executor.servlet;

import java.util.List;
import java.util.Map;

import org.springframework.util.Assert;

import com.rapid.im.framework.network.configure.domain.NetConfigurer;
import com.rapid.im.framework.network.configure.domain.NetFunctionRequest;
import com.rapid.im.framework.network.executor.parameter.NetFunctionRequestPreparement;
import com.rapid.j2ee.framework.core.io.http.HttpGetClient;
import com.rapid.j2ee.framework.core.io.http.HttpPostClient;
import com.rapid.j2ee.framework.core.utils.StringUtils;

public class NetFunctionHttpPostFileRequester extends
		NetFunctionAbstractRequester {

	public NetFunctionHttpPostFileRequester(NetConfigurer netConfigurer,
			NetFunctionRequest netFunctionRequest) {
		super(netConfigurer, netFunctionRequest);

	}

	@Override
	protected String doSend(String url, String requestContent,
			NetFunctionRequest netFunctionRequest,
			NetFunctionRequestPreparement request) {
		
		System.out.println(request.getContentMediaResource());

		Assert.notNull(request.getContentMediaResource(),
				"Please provide a upload file!");

		System.out.println("url:" + url.trim());

		HttpPostClient httpPostClient = new HttpPostClient(url);

		httpPostClient.addAttachedFile(netFunctionRequest
				.getNetParameterValueByName(Parameter_File_FieldName), request
				.getContentMediaResource());

		return httpPostClient.executeContent();
	}

	private static final String Parameter_File_FieldName = "File_FieldName";

}
