package com.rapid.im.framework.network.executor.servlet;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.fileupload.FileUpload;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.Assert;

import com.rapid.im.framework.network.configure.domain.NetConfigurer;
import com.rapid.im.framework.network.configure.domain.NetFunctionResponse;
import com.rapid.im.framework.network.executor.parameter.NetFunctionRequestPreparement;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.io.http.HttpResponseEntity;
import com.rapid.j2ee.framework.core.io.net.ResourceStorageClient;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.spring.SpringApplicationContextHolder;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.UUIDGenerator;

public class NetFunctionJsonFileResourceStorageClientResponser extends
		NetFunctionJsonFileResponser {

	public NetFunctionJsonFileResourceStorageClientResponser(
			NetConfigurer netConfigurer, NetFunctionResponse netFunctionResponse) {
		super(netConfigurer, netFunctionResponse);

	}

	@Override
	protected Object putFile(String className,
			HttpResponseEntity httpResponseEntity,
			NetFunctionResponse netFunctionResponse,
			NetFunctionRequestPreparement requestPreparement) {

		try {
			ResourceStorageClient resourceStorageClient = this
					.getResourceStorageClient(netFunctionResponse);

			String fileExtType = StringUtils.trimToEmpty(StringUtils
					.substringAfterLast(httpResponseEntity.getFileName(), "."),
					".data");

			String storeFileName = UUIDGenerator.nextUUID() + "." + fileExtType;

			String storeFile = FileUtils
					.getFullFilePathsName(
							storeFileName,
							netFunctionResponse
									.getNetParameterValueByName("ResourceStorageClient_Category"),
							netFunctionResponse
									.getNetParameterValueByName("ResourceStorageClient_SubCategory"));
			resourceStorageClient
					.put(
							netFunctionResponse
									.getNetParameterValueByName("ResourceStorageClient_Category"),
							netFunctionResponse
									.getNetParameterValueByName("ResourceStorageClient_SubCategory"),
							storeFileName, httpResponseEntity.getContent());

			Map<String, Object> maps = new HashMap<String, Object>(15);

			maps.put("content_type", httpResponseEntity.getContentType()
					.getValue());
			maps.put("contentType", httpResponseEntity.getContentType()
					.getValue());
			maps.put("content_length", httpResponseEntity.getContentLength());
			maps.put("contentLength", httpResponseEntity.getContentLength());

			maps.put("contentDisposition", httpResponseEntity
					.getHeaderValue("Content-disposition"));
			maps.put("content_disposition", httpResponseEntity
					.getHeaderValue("Content-disposition"));

			maps.put("fileName", httpResponseEntity.getFileName());
			maps.put("file_name", httpResponseEntity.getFileName());

			maps.put("storeFileName", storeFileName);
			maps.put("store_filename", storeFileName);

			maps.put("storeFileLocation", storeFile);
			maps.put("store_file_location", storeFile);

			return BeanUtils.populate(ConstructorUtils.newInstance(className), maps);
			
		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	private ResourceStorageClient getResourceStorageClient(
			NetFunctionResponse netFunctionResponse) {

		Assert
				.isTrue(SpringApplicationContextHolder
						.isApplicationContextHolden(),
						"Please inject spring instance to SpringApplicationContextHolder!");

		String qualifier = netFunctionResponse
				.getNetParameterValueByName("ResourceStorageClient_Qualifier");

		ResourceStorageClient resourceStorageClient = null;

		if (TypeChecker.isEmpty(qualifier)) {
			return SpringApplicationContextHolder
					.getBean(ResourceStorageClient.class);
		}

		return (ResourceStorageClient) SpringApplicationContextHolder
				.getBean(qualifier);
	}

}
